package cn.com.duiba.paycenter.dto.payment.charge.shenzhenumsunionpay;

import cn.com.duiba.paycenter.dto.payment.charge.BaseChargeRequest;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * 深圳银联对接天满saas服务平台的支付
 *
 * @author zhangdaqing
 * @date 2023/07/13
 */
public class UnionPayUmsRefundRequest implements Serializable {

    /**
     * 退款金额
     */
    @NotNull(message = "退款金额不能为空")
    private Long refundAmount;

    /**
     * 订单号
     */
    @NotBlank(message = "订单号不能为空")
    private String bizOrderNo;

    /**
     * 交易号
     */
    private String chargeOrderNo;

    /**
     * 子订单
     */
    private Long ordersItemId;

    public Long getOrdersItemId() {
        return ordersItemId;
    }

    public void setOrdersItemId(Long ordersItemId) {
        this.ordersItemId = ordersItemId;
    }

    public Long getRefundAmount() {
        return refundAmount;
    }

    public void setRefundAmount(Long refundAmount) {
        this.refundAmount = refundAmount;
    }

    public String getBizOrderNo() {
        return bizOrderNo;
    }

    public void setBizOrderNo(String bizOrderNo) {
        this.bizOrderNo = bizOrderNo;
    }

    public String getChargeOrderNo() {
        return chargeOrderNo;
    }

    public void setChargeOrderNo(String chargeOrderNo) {
        this.chargeOrderNo = chargeOrderNo;
    }
}
