package cn.com.duiba.paycenter.dto.payment.charge.wxpay;

import javax.validation.constraints.Min;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;


/**
 * 微信转账订单请求
 *
 */
public class WxTransferPaySendRequest extends WxTransferPayQueryRequest {
    private static final long serialVersionUID = -202691032793973285L;

    /**
     * 用户openid
     * 此 openId 归属于 上游APP的"业务主体"，而非上游业务APP
     */
    @NotBlank(message = "openId不能为空")
    private String openId;

    /**
     * 付款金额/红包总金额，单位分
     */
    @Min(value = 0, message = "amount不能小于0")
    @NotNull(message = "amount不能为空")
    private Integer amount;

    /**
     * 调用接口的机器Ip地址
     */
    @NotBlank(message = "ip不能为空")
    private String spbillCreateIp;

    /**
     * 备注
     */
    @NotBlank(message = "desc不能为空")
    private String desc;

    /**
     * 0:不校验真实姓名 , 1:强校验真实姓名
     */
    @NotNull(message = "checkName不能为空")
    private Integer checkName;

    /**
     * 设备号
     */
    private String deviceInfo;



    public String getOpenId() {
        return openId;
    }

    public void setOpenId(String openId) {
        this.openId = openId;
    }

    public Integer getAmount() {
        return amount;
    }

    public void setAmount(Integer amount) {
        this.amount = amount;
    }

    public String getSpbillCreateIp() {
        return spbillCreateIp;
    }

    public void setSpbillCreateIp(String spbillCreateIp) {
        this.spbillCreateIp = spbillCreateIp;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public Integer getCheckName() {
        return checkName;
    }

    public void setCheckName(Integer checkName) {
        this.checkName = checkName;
    }

    public String getDeviceInfo() {
        return deviceInfo;
    }

    public void setDeviceInfo(String deviceInfo) {
        this.deviceInfo = deviceInfo;
    }
}
