package cn.com.duiba.paycenter.dto.payment.charge.cmb;

import java.io.Serializable;

/**
 *  招商银行-掌上生活-开放平台-H5支付-退款查询response
 *
 * @author songp
 * @date 2024/2/18 9:12 下午
 */
public class CmbLifeRefundQueryResponse implements Serializable {

    private static final long serialVersionUID = 8535820434069399311L;


    /**
     * 星速台默认错误码
     */
    public static final String DEFAULT_ERROR_CODE = "99999";

    public static final String SUCCESS_CODE = "1000";



    /**
     * 返回码 1000：查询成功，9501：参数错误，1001：查询异常，99999-payCenter定义发起异常
     */
    private String respCode;

    /**
     * 返回话术
     */
    private String respMsg;

    /**
     * 时间戳，格式yyyyMMddHHmmss
     */
    private String date;

    /**
     * 退货结果 1：待退款，2：退款成功，3：退款失败，4：退款未知，0：未找到退款订单
     */
    private int refundStatus;

    /**
     * 退款参考号，退款失败则不存在
     */
    private String refundRefNum;

    /**
     * 合作方密钥对别名
     */
    private String keyAlias;

    /**
     * 掌上生活密钥对别名
     */
    private String cmbKeyAlias;

    /**
     * 签名，具体详见《签名与验签》文档
     */
    private String sign;

    public String getRespCode() {
        return respCode;
    }

    public void setRespCode(String respCode) {
        this.respCode = respCode;
    }

    public String getRespMsg() {
        return respMsg;
    }

    public void setRespMsg(String respMsg) {
        this.respMsg = respMsg;
    }

    public String getDate() {
        return date;
    }

    public void setDate(String date) {
        this.date = date;
    }

    public int getRefundStatus() {
        return refundStatus;
    }

    public void setRefundStatus(int refundStatus) {
        this.refundStatus = refundStatus;
    }

    public String getRefundRefNum() {
        return refundRefNum;
    }

    public void setRefundRefNum(String refundRefNum) {
        this.refundRefNum = refundRefNum;
    }

    public String getKeyAlias() {
        return keyAlias;
    }

    public void setKeyAlias(String keyAlias) {
        this.keyAlias = keyAlias;
    }

    public String getCmbKeyAlias() {
        return cmbKeyAlias;
    }

    public void setCmbKeyAlias(String cmbKeyAlias) {
        this.cmbKeyAlias = cmbKeyAlias;
    }

    public String getSign() {
        return sign;
    }

    public void setSign(String sign) {
        this.sign = sign;
    }
}
