package cn.com.duiba.paycenter.dto.payment.charge.cmb;

import java.io.Serializable;

/**
 * 招商银行-掌上生活-开放平台-H5支付-退款response
 *
 * @author songp
 * @date 2024/2/18 9:07 下午
 */
public class CmbLifeRefundResponse implements Serializable {

    private static final long serialVersionUID = 8535820434069399313L;

    /**
     * 星速台默认错误码
     */
    public static final String DEFAULT_ERROR_CODE = "99999";

    public static final String SUCCESS_CODE = "1000";

    /**
     * 返回码 1000：退款成功，9501：参数错误，1001：退款异常
     */
    private String respCode;

    /**
     * 返回话术
     */
    private String respMsg;

    /**
     * 时间戳，格式为yyyyMMddHHmmss
     */
    private String date;

    /**
     * 退款金额（单位分）
     */
    private String amount;

    /**
     * 退款积分
     */
    private String bonus;

    /**
     * 退货结果 1：待退款，2：退款成功，3：退款失败，4：退款未知
     */
    private String refundStatus;

    /**
     * 退款参考号，退款失败则不存在
     */
    private String refundRefNum;

    /**
     * 掌上生活密钥对别名
     */
    private String cmbKeyAlias;

    /**
     * 签名，具体详见《签名与验签》文档
     */
    private String sign;



    public String getRespCode() {
        return respCode;
    }

    public void setRespCode(String respCode) {
        this.respCode = respCode;
    }

    public String getRespMsg() {
        return respMsg;
    }

    public void setRespMsg(String respMsg) {
        this.respMsg = respMsg;
    }

    public String getDate() {
        return date;
    }

    public void setDate(String date) {
        this.date = date;
    }

    public String getAmount() {
        return amount;
    }

    public void setAmount(String amount) {
        this.amount = amount;
    }

    public String getBonus() {
        return bonus;
    }

    public void setBonus(String bonus) {
        this.bonus = bonus;
    }

    public String getRefundStatus() {
        return refundStatus;
    }

    public void setRefundStatus(String refundStatus) {
        this.refundStatus = refundStatus;
    }

    public String getRefundRefNum() {
        return refundRefNum;
    }

    public void setRefundRefNum(String refundRefNum) {
        this.refundRefNum = refundRefNum;
    }

    public String getCmbKeyAlias() {
        return cmbKeyAlias;
    }

    public void setCmbKeyAlias(String cmbKeyAlias) {
        this.cmbKeyAlias = cmbKeyAlias;
    }

    public String getSign() {
        return sign;
    }

    public void setSign(String sign) {
        this.sign = sign;
    }
}
