package cn.com.duiba.paycenter.dto.payment.charge.icbcelife;

import cn.com.duiba.paycenter.dto.payment.charge.BaseChargeRequest;

import javax.validation.constraints.NotBlank;

/**
 * @author haojiahong
 * @date 2022-06-10
 */
public class IcbcElife4AppChargeRequest extends BaseChargeRequest {

    private static final long serialVersionUID = 7499591634521646947L;


    /**
     * 工行其他接口传递的用户唯一标识
     * 必填
     */
    @NotBlank(message = "工行用户唯一标识必填")
    private String custId;

    /**
     * 交易日期，格式:yyyyMMdd
     * 必填
     */
    @NotBlank(message = "交易日期必填")
    private String tradeDate;

    /**
     * 交易时间，格式: HHmmss
     * 必填
     */
    @NotBlank(message = "交易时间必填")
    private String tradeTime;

    /**
     * 商户订单有效期，单位：秒，必须小于24小时
     * 必填
     */
    @NotBlank(message = "商户订单有效期必填")
    private String payExpire;

    /**
     * 商户接收支付成功通知消息URL,当notify_flag为1时必输，最大长度100个字符
     */
    private String notifyUrl;

    /**
     * 商户是否开启通知接口 0-否；1-是；非1按0处理
     * 必填
     */
    @NotBlank(message = "商户是否开启通知接口必填")
    private String notifyFlag;

    /**
     * 是否买单页自提交标识，0-否；1-是；非1按0处理
     * 必填
     */
    @NotBlank(message = "是否买单页自提交标识必填")
    private String autoSubmitFlag;

    /**
     * 商户附加数据，最多21个汉字字符，原样返回；如业务要求上送营销人员编号，则按照“staffid:num”的格式上送，其中“staffid:”为英文字符，
     * “num”为开头允许为0的9位整数，由工行业务人员提供
     */
    private String attach;

    /**
     * 第三方商品名称，最多33个汉字字符
     */
    private String goodsName;

    /**
     * 全积分抵扣标志，0-否，1-是；非1按0处理
     */
    private String allPointsFlag;

    /**
     * 兑换商品所需积分，当all_points_flag为1时必输；订单金额与积分兑换比率由业务规则确定
     */
    private String goodPoints;

    /**
     * 分期付款标志，0-仅全款付款，1-仅分期付款；非1按0处理；全积分抵扣标识与分期付款标识不可同时为1
     */
    private String installmentFlag;

    /**
     * 分期期数，当installment_flag为1时必输，为大于1的正整数
     */
    private String installmentTimes;

    /**
     * 支付卡类型，从左往右：第1位：工行信用卡支持标志；第2位：工行借记卡支持标志；第3位：非工行银联卡支持标志。各标志位，0-否；1-是；非1按0处理
     */
    private String cardType;

    public String getCustId() {
        return custId;
    }

    public void setCustId(String custId) {
        this.custId = custId;
    }

    public String getTradeDate() {
        return tradeDate;
    }

    public void setTradeDate(String tradeDate) {
        this.tradeDate = tradeDate;
    }

    public String getTradeTime() {
        return tradeTime;
    }

    public void setTradeTime(String tradeTime) {
        this.tradeTime = tradeTime;
    }

    public String getPayExpire() {
        return payExpire;
    }

    public void setPayExpire(String payExpire) {
        this.payExpire = payExpire;
    }

    public String getNotifyUrl() {
        return notifyUrl;
    }

    public void setNotifyUrl(String notifyUrl) {
        this.notifyUrl = notifyUrl;
    }

    public String getNotifyFlag() {
        return notifyFlag;
    }

    public void setNotifyFlag(String notifyFlag) {
        this.notifyFlag = notifyFlag;
    }

    public String getAutoSubmitFlag() {
        return autoSubmitFlag;
    }

    public void setAutoSubmitFlag(String autoSubmitFlag) {
        this.autoSubmitFlag = autoSubmitFlag;
    }

    public String getAttach() {
        return attach;
    }

    public void setAttach(String attach) {
        this.attach = attach;
    }

    public String getGoodsName() {
        return goodsName;
    }

    public void setGoodsName(String goodsName) {
        this.goodsName = goodsName;
    }

    public String getAllPointsFlag() {
        return allPointsFlag;
    }

    public void setAllPointsFlag(String allPointsFlag) {
        this.allPointsFlag = allPointsFlag;
    }

    public String getGoodPoints() {
        return goodPoints;
    }

    public void setGoodPoints(String goodPoints) {
        this.goodPoints = goodPoints;
    }

    public String getInstallmentFlag() {
        return installmentFlag;
    }

    public void setInstallmentFlag(String installmentFlag) {
        this.installmentFlag = installmentFlag;
    }

    public String getInstallmentTimes() {
        return installmentTimes;
    }

    public void setInstallmentTimes(String installmentTimes) {
        this.installmentTimes = installmentTimes;
    }

    public String getCardType() {
        return cardType;
    }

    public void setCardType(String cardType) {
        this.cardType = cardType;
    }
}
