package cn.com.duiba.paycenter.dto.payment.charge.weibo;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

import java.io.Serializable;

/**
 * 微博支付回调、退款回调同一个接口，这里参数也放到一起
 */
@Data
public class WeiboChargeNotifyData implements Serializable {
    private static final long serialVersionUID = 7634992480962538712L;
    /**
     * 通知类型：退款
     */
    public static final String NOTIFY_TYPE_REFUND = "PAY_REFUND_NOTIFY";
    /**
     * 支付状态-待支付
     */
    public static final String PAY_STATUS_PENDING = "PAY_STATUS_PENDING";
    /**
     * 支付状态-成功
     */
    public static final String PAY_STATUS_SUCCESS = "PAY_STATUS_SUCCESS";
    /**
     * 支付状态-关闭
     */
    public static final String PAY_STATUS_CLOSED = "PAY_STATUS_CLOSED";

    /**
     * 退款状态-退款中
     */
    public static final String REFUND_STATUS_PENDING = "PAY_REFUND_STATUS_PENDING";

    /**
     * 退款状态：退款成功
     */
    public static final String REFUND_STATUS_SUCCESS = "PAY_REFUND_STATUS_SUCCESS";

    /**
     * 退款状态-退款失败
     */
    public static final String REFUND_STATUS_FAIL = "PAY_REFUND_STATUS_FAIL";

    /**
     * 通知类型，
     * 退款通知才有此参数
     * 退款通知：PAY_REFUND_NOTIFY
     */
    @JsonProperty(value = "notify_type")
    private String notifyType;

    /**
     * 微博支付单id
     */
    @JsonProperty(value = "pay_id")
    private Long payId;

    /**
     * 外部订单 ID
     */
    @JsonProperty(value = "out_pay_id")
    private String outPayId;

    /**
     * 服务商微博 UID
     */
    @JsonProperty(value = "seller_id")
    private long sellerId;

    /**
     * 买家微博 UID
     */
    @JsonProperty(value = "buyer_id")
    private long buyerId;

    /**
     * 支付退款id
     * 退款通知才有此参数
     */
    @JsonProperty(value = "refund_id")
    private Long refundId;

    /**
     * 支付退款金额
     * 退款通知才有此参数
     */
    @JsonProperty(value = "refund_amount")
    private Integer refundAmount;

    /**
     * 退款时间，格式为：Y-m-d H:i:s
     * 退款通知才有此参数
     */
    private String refundTime;

    /**
     * 退分账标记
     * 退款通知才有此参数
     * 0 代表仅退款，1 代表有退分账 （目前业务没有分账）
     */
    @JsonProperty(value = "refund_transfer")
    private int refundTransfer;

    /** 支付方式（3：微信，4：支付宝，5：花呗分期） */
    @JsonProperty(value = "pay_method")
    private int payMethod;

    /** 商品名称 */
    @JsonProperty(value = "subject")
    private String subject;

    /** 商品总价（以分为单位） */
    @JsonProperty(value = "total_amount")
    private int totalAmount;

    /** 商品描述 */
    @JsonProperty(value = "body")
    private String body;

    /** appkey */
    @JsonProperty(value = "appkey")
    private String appkey;

    /** 附加信息 */
    @JsonProperty(value = "extra")
    private String extra;

    /** 支付单状态（PAY_STATUS_PENDING: 待支付，PAY_STATUS_SUCCESS: 已支付，PAY_STATUS_CLOSED: 已关闭） */
    @JsonProperty(value = "status")
    private String status;

    /** 支付时间，格式为：Y-m-d H:i:s */
    @JsonProperty(value = "pay_time")
    private String payTime;

    /** 签名 */
    @JsonProperty(value = "sign")
    private String sign;

    /**
     * 签名类型
     */
    @JsonProperty(value = "sign_type")
    private String signType;
}
