package cn.com.duiba.paycenter.dto.payment.charge.weibo;

import cn.com.duiba.paycenter.dto.payment.charge.BaseChargeRequest;

public class WeiboChargeRequest extends BaseChargeRequest {

    private static final long serialVersionUID = 1L;


    // 异步通知地址，将支付结果作为参数异步通知到业务方系统的此地址
    private String notifyUrl;

    // 支付完成回调页地址，支付完成后同步返回到业务方的页面
    private String returnUrl;

    // 商品名称，注意：不可使用特殊字符，如 /，=，& 等
    private String subject;

    // 超时时间，单位秒，最小超时时间 60s，默认值 1 天，即 86400，最大为 15 天
    private Integer expire;

    // ----------- 以下非必须 ------------

    // 商品描述
    private String body;

    // 附加信息，同步和异步回调时会带上此参数
    private String extra;

    // 定制分享到微博，0: 不显示, 1: 显示(默认不勾选), 2: 显示(默认勾选)
    private Integer cfgShareOpt;

    // 定制关注，0: 不显示, 1: 显示(默认不勾选), 2: 显示(默认勾选)
    private Integer cfgFollowOpt;

    // 是否显示支付完成页，0: 默认值，显示完成页；1: 不展示成功页，直接跳转到商户指定的 return_url
    private Integer cfgDirectJump;

    // 商户是否贴息，1: 贴息，2: 不贴息
    private Integer subsidyInterest;

    // 商品类型，1：实物商品；2：虚拟商品
    private Integer goodsType;

    // 半层收银台，增加半层白名单后，默认进入半层收银台。传 nohalf 参数则不使用半层
    private String halfControl;

    public String getNotifyUrl() {
        return notifyUrl;
    }

    public void setNotifyUrl(String notifyUrl) {
        this.notifyUrl = notifyUrl;
    }

    public String getReturnUrl() {
        return returnUrl;
    }

    public void setReturnUrl(String returnUrl) {
        this.returnUrl = returnUrl;
    }

    public String getSubject() {
        return subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public String getBody() {
        return body;
    }

    public void setBody(String body) {
        this.body = body;
    }

    public Integer getExpire() {
        return expire;
    }

    public void setExpire(Integer expire) {
        this.expire = expire;
    }

    public String getExtra() {
        return extra;
    }

    public void setExtra(String extra) {
        this.extra = extra;
    }

    public Integer getCfgShareOpt() {
        return cfgShareOpt;
    }

    public void setCfgShareOpt(Integer cfgShareOpt) {
        this.cfgShareOpt = cfgShareOpt;
    }

    public Integer getCfgFollowOpt() {
        return cfgFollowOpt;
    }

    public void setCfgFollowOpt(Integer cfgFollowOpt) {
        this.cfgFollowOpt = cfgFollowOpt;
    }

    public Integer getCfgDirectJump() {
        return cfgDirectJump;
    }

    public void setCfgDirectJump(Integer cfgDirectJump) {
        this.cfgDirectJump = cfgDirectJump;
    }

    public Integer getSubsidyInterest() {
        return subsidyInterest;
    }

    public void setSubsidyInterest(Integer subsidyInterest) {
        this.subsidyInterest = subsidyInterest;
    }

    public Integer getGoodsType() {
        return goodsType;
    }

    public void setGoodsType(Integer goodsType) {
        this.goodsType = goodsType;
    }

    public String getHalfControl() {
        return halfControl;
    }

    public void setHalfControl(String halfControl) {
        this.halfControl = halfControl;
    }
}
