package cn.com.duiba.paycenter.dto.payment.charge.weibo;

import lombok.Data;

import java.io.Serializable;

@Data
public class WeiboSettleData implements Serializable {
    private static final long serialVersionUID = -4650005956741475678L;

    /**
     * 结算状态常量
     */
    public static final String STATUS_PENDING = "PAY_SETTLE_STATUS_PENDING";        // 待处理
    public static final String STATUS_PROCESSING = "PAY_SETTLE_STATUS_PROCESSING";  // 处理中
    public static final String STATUS_SUCCESS = "PAY_SETTLE_STATUS_SUCCESS";        // 处理成功
    public static final String STATUS_FAIL = "PAY_SETTLE_STATUS_FAIL";              // 处理失败
    public static final String STATUS_TBC = "PAY_SETTLE_STATUS_TBC";
    /**
     * 微博结算单号，唯一标识结算单。
     * 必填字段。
     */
    private int settleId;

    /**
     * 微博支付单号，唯一标识支付单。
     * 必填字段。
     */
    private int payId;

    /**
     * 结算金额，单位为分。
     * 必填字段。
     */
    private int settleAmount;

    /**
     * 结算状态，表示结算处理的当前状态。
     * 必填字段。
     * <ul>
     *     <li>STATUS_PENDING - 待处理</li>
     *     <li>STATUS_PROCESSING - 处理中</li>
     *     <li>STATUS_SUCCESS - 处理成功，即结算成功</li>
     *     <li>STATUS_FAIL - 处理失败，即结算失败</li>
     *     <li>STATUS_TBC - 处理结果待确认</li>
     * </ul>
     */
    private String status;

    /**
     * 状态描述，提供结算状态的附加信息。
     * 必填字段。
     */
    private String desc;

    /**
     * 冻结状态，表示结算金额是否被冻结。
     * 条件返回，1 表示已冻结，2 表示已解冻。
     * 选填字段。
     */
    private int freeze;
}
