package cn.com.duiba.paycenter.dto.payment.charge.cmb;

import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * 招商银行-掌上生活-开放平台-H5支付-退款request
 *
 * @author songp
 * @date 2024/2/18 9:07 下午
 */
public class CmbLifeRefundRequest implements Serializable {

    private static final long serialVersionUID = 8535820434069399314L;

    /**
     * 星速台下单支付订单号
     */
    @NotNull(message = "星速台订单号不能为空")
    private String bizOrderNo;

    /**
     * 退款金额（单位分）
     */
    @NotNull(message = "退款金额不能为空")
    @Min(value = 1, message = "金额必须大于1分")
    private String amount;

    /**
     * 退款流水号，不可重复，该值合作方需落地，退款订单状态查询接口需传，不长于40位
     */
    @NotNull(message = "退款流水号不能为空")
    private String refundToken;

    public String getBizOrderNo() {
        return bizOrderNo;
    }

    public void setBizOrderNo(String bizOrderNo) {
        this.bizOrderNo = bizOrderNo;
    }

    public String getAmount() {
        return amount;
    }

    public void setAmount(String amount) {
        this.amount = amount;
    }

    public String getRefundToken() {
        return refundToken;
    }

    public void setRefundToken(String refundToken) {
        this.refundToken = refundToken;
    }
}
