package cn.com.duiba.paycenter.dto.payment.charge.duibaLive.mp;

import cn.com.duiba.paycenter.dto.payment.charge.BaseChargeResponse;
import com.alibaba.fastjson.JSON;

/**
 * @Author xujing
 * @Date 2021/5/18 1:57 下午
 */
public class DuibaLiveMpChargeResponse extends BaseChargeResponse {

    private static final long serialVersionUID = 4909651001674412949L;

    /**
     * 小程序appId
     */
    private String appId;

    /**
     * 时间戳
     */
    private String timeStamp;

    /**
     * 随机字符串
     */
    private String nonceStr;

    /**
     * 下单返回的参数
     */
    private String packageStr;

    /**
     * 支付签名
     */
    private String paySign;

    /**
     * 签名方式
     */
    private String signType;


    @Override
    public String getExtra() {
        return JSON.toJSONString(new DuibaLiveMpResData(this.getAppId(), this.getTimeStamp(), this.getNonceStr(), this.getPackageStr(), this.getPaySign(), this.getSignType()));
    }

    public String getAppId() {
        return appId;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public String getTimeStamp() {
        return timeStamp;
    }

    public void setTimeStamp(String timeStamp) {
        this.timeStamp = timeStamp;
    }

    public String getNonceStr() {
        return nonceStr;
    }

    public void setNonceStr(String nonceStr) {
        this.nonceStr = nonceStr;
    }

    public String getPackageStr() {
        return packageStr;
    }

    public void setPackageStr(String packageStr) {
        this.packageStr = packageStr;
    }

    public String getPaySign() {
        return paySign;
    }

    public void setPaySign(String paySign) {
        this.paySign = paySign;
    }

    public String getSignType() {
        return signType;
    }

    public void setSignType(String signType) {
        this.signType = signType;
    }
}
