package cn.com.duiba.paycenter.dto.payment.charge.elife.dto;

import java.io.Serializable;

public class IcbcELifeOrderInfo implements Serializable {

    private static final long serialVersionUID = 8535820434069399302L;

    /**
     * 交易日期时间
     * 必输，
     * 格式为：YYYYMMDDHHmmss
     * 要求在银行系统当前时间的前1小时和后12小时范围内，否则判定交易时间非法。
     */
    private String orderDate;

    /**
     * 订单号，必输，
     * 客户支付后商户网站产生的一个唯一的定单号，该订单号应该在相当长的时间内不重复。工行通过订单号加订单日期来唯一确认一笔订单的重复性。
     */
    private String orderid;

    /**
     * 订单金额
     * 必输，
     * 客户支付订单的总金额，一笔订单一个，以分为单位。不可以为零，必需符合金额标准。
     */
    private String amount;

    /**
     * 分期付款期数
     * 必输，每笔订单一个；
     * 取值：1、3、6、9、12、18、24；1代表全额付款，必须为以上述值，否则订单校验不通过。
     */
    private String installmentTimes;

    /**
     * 支付币种
     * 必输，
     * 用来区分一笔支付的币种，目前工行只支持使用人民币（001）支付。
     * 取值： “001”
     */
    private String curType;

    /**
     * 商户代码
     * 必输，
     * 唯一确定一个商户的代码，由商户在工行开户时，由工行告知商户。
     */
    private String merID;

    /**
     * 商户账号
     * 必输，
     * 商户入账账号，只能交易时指定。（商户付给银行手续费的账户，可以在开户的时候指定，也可以用交易指定方式；用交易指定方式则使用此商户账号）
     */
    private String merAcct;

    public String getOrderDate() {
        return orderDate;
    }

    public void setOrderDate(String orderDate) {
        this.orderDate = orderDate;
    }

    public String getOrderid() {
        return orderid;
    }

    public void setOrderid(String orderid) {
        this.orderid = orderid;
    }

    public String getAmount() {
        return amount;
    }

    public void setAmount(String amount) {
        this.amount = amount;
    }

    public String getInstallmentTimes() {
        return installmentTimes;
    }

    public void setInstallmentTimes(String installmentTimes) {
        this.installmentTimes = installmentTimes;
    }

    public String getCurType() {
        return curType;
    }

    public void setCurType(String curType) {
        this.curType = curType;
    }

    public String getMerID() {
        return merID;
    }

    public void setMerID(String merID) {
        this.merID = merID;
    }

    public String getMerAcct() {
        return merAcct;
    }

    public void setMerAcct(String merAcct) {
        this.merAcct = merAcct;
    }
}
