package cn.com.duiba.paycenter.dto.payment.charge.hello;

import cn.com.duiba.paycenter.dto.payment.charge.BaseChargeRequest;

import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

/**
 * Created by sunyan on 2019/10/24.
 */
public class HelloPayChargeRequest extends BaseChargeRequest{
    private static final long serialVersionUID = 160792273305088981L;
    /**
     * 客户端ip
     */
    @Size(max = 16, message = "ip的长度超过16")
    private String ip;

    /**
     * 开发者用户id
     */
    @NotNull(message = "开发者用户id不能为空")
    private String uid;

    /**
     * 订单描述
     */
    @NotNull(message = "订单描述不能为空")
    @Size(max = 128, message = "订单描述超过128")
    private String desc;

    public String getIp() {
        return ip;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public String getUid() {
        return uid;
    }

    public void setUid(String uid) {
        this.uid = uid;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }
}
