/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.paycenter.enums.duibaaccount;

import java.util.Arrays;
import java.util.Objects;

public enum AppAccountTypeEnum {
    BALANCE(1, "\u4f59\u989d\u8d26\u6237"),
    SETTLE(2, "\u5f85\u7ed3\u7b97\u8d26\u6237"),
    MARK(3, "\u6807\u8bb0\u8d26\u6237");

    private Integer code;
    private String desc;

    private AppAccountTypeEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static String getDescByCode(Integer code) {
        if (Objects.isNull(code)) {
            return "";
        }
        AppAccountTypeEnum accountTypeEnum = AppAccountTypeEnum.getByCode(code);
        if (Objects.nonNull((Object)accountTypeEnum)) {
            return accountTypeEnum.getDesc();
        }
        return "";
    }

    public static AppAccountTypeEnum getByCode(Integer code) {
        return Arrays.stream(AppAccountTypeEnum.values()).filter(a -> a.code.equals(code)).findFirst().orElse(null);
    }

    public Integer getCode() {
        return this.code;
    }

    public String getDesc() {
        return this.desc;
    }
}

