/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.paycenter.enums.duibaaccount;

import java.util.Arrays;
import java.util.Objects;

public enum SupplierAccountTypeEnum {
    BALANCE(1, "\u4f59\u989d\u8d26\u6237"),
    SETTLE(2, "\u5f85\u7ed3\u7b97\u8d26\u6237");

    private Integer code;
    private String desc;

    private SupplierAccountTypeEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static String getDescByCode(Integer code) {
        if (Objects.isNull(code)) {
            return "";
        }
        SupplierAccountTypeEnum accountTypeEnum = SupplierAccountTypeEnum.getByCode(code);
        if (Objects.nonNull((Object)accountTypeEnum)) {
            return accountTypeEnum.getDesc();
        }
        return "";
    }

    public static SupplierAccountTypeEnum getByCode(Integer code) {
        return Arrays.stream(SupplierAccountTypeEnum.values()).filter(a -> a.code.equals(code)).findFirst().orElse(null);
    }

    public Integer getCode() {
        return this.code;
    }

    public String getDesc() {
        return this.desc;
    }
}

