package cn.com.duiba.paycenter.dto.payment.charge.alipay;

import cn.com.duiba.paycenter.dto.payment.charge.BaseChargeResponse;
import com.alibaba.fastjson.JSONObject;

/**
 * 支付宝预授权支付响应类
 * 
 * @author AI Assistant
 * @date 2024/12/19
 */
public class AlipayPreAuthChargeResponse extends BaseChargeResponse {
    private static final long serialVersionUID = 7218410823559348340L;

    /**
     * 预授权订单号
     */
    private String authNo;

     /**
     * 拉起支付宝的参数
     */
    private String body;

    

    /**
     * 预授权金额，单位为分
     */
    private Integer preAuthAmount;

    /**
     * 预授权状态
     * INIT：初始
     * SUCCESS：成功
     * CLOSED：关闭
     */
    private String authStatus;

    /**
     * 预授权冻结金额，单位为分
     */
    private Integer freezeAmount;

    /**
     * 预授权有效期
     */
    private String authValidTime;

    /**
     * 支付宝交易号
     */
    private String tradeNo;

    /**
     * 支付宝用户ID
     */
    private String buyerId;

    /**
     * 支付宝用户登录账号
     */
    private String buyerLogonId;

    /**
     * 支付宝应用ID
     */
    private String aliAppId;

    /**
     * 渠道模式
     */
    private Integer channelMode;

    /**
     * 预授权完成时间
     */
    private String gmtAuthSuccess;

    /**
     * 预授权关闭时间
     */
    private String gmtAuthClose;

    /**
     * 预授权资金解冻时间
     */
    private String gmtAuthUnfreeze;

    /**
     * 芝麻信用免押金额，单位为分
     */
    private Integer depositAmount;

    /**
     * 芝麻信用免押状态
     */
    private String creditStatus;


    public String getBody() {
        return body;
    }

     public void setBody(String body) {
         this.body = body;
     }

    public String getAuthNo() {
        return authNo;
    }

    public void setAuthNo(String authNo) {
        this.authNo = authNo;
    }

    public Integer getPreAuthAmount() {
        return preAuthAmount;
    }

    public void setPreAuthAmount(Integer preAuthAmount) {
        this.preAuthAmount = preAuthAmount;
    }

    public String getAuthStatus() {
        return authStatus;
    }

    public void setAuthStatus(String authStatus) {
        this.authStatus = authStatus;
    }

    public Integer getFreezeAmount() {
        return freezeAmount;
    }

    public void setFreezeAmount(Integer freezeAmount) {
        this.freezeAmount = freezeAmount;
    }

    public String getAuthValidTime() {
        return authValidTime;
    }

    public void setAuthValidTime(String authValidTime) {
        this.authValidTime = authValidTime;
    }

    public String getTradeNo() {
        return tradeNo;
    }

    public void setTradeNo(String tradeNo) {
        this.tradeNo = tradeNo;
    }

    public String getBuyerId() {
        return buyerId;
    }

    public void setBuyerId(String buyerId) {
        this.buyerId = buyerId;
    }

    public String getBuyerLogonId() {
        return buyerLogonId;
    }

    public void setBuyerLogonId(String buyerLogonId) {
        this.buyerLogonId = buyerLogonId;
    }

    public String getAliAppId() {
        return aliAppId;
    }

    public void setAliAppId(String aliAppId) {
        this.aliAppId = aliAppId;
    }

    public Integer getChannelMode() {
        return channelMode;
    }

    public void setChannelMode(Integer channelMode) {
        this.channelMode = channelMode;
    }

    public String getGmtAuthSuccess() {
        return gmtAuthSuccess;
    }

    public void setGmtAuthSuccess(String gmtAuthSuccess) {
        this.gmtAuthSuccess = gmtAuthSuccess;
    }

    public String getGmtAuthClose() {
        return gmtAuthClose;
    }

    public void setGmtAuthClose(String gmtAuthClose) {
        this.gmtAuthClose = gmtAuthClose;
    }

    public String getGmtAuthUnfreeze() {
        return gmtAuthUnfreeze;
    }

    public void setGmtAuthUnfreeze(String gmtAuthUnfreeze) {
        this.gmtAuthUnfreeze = gmtAuthUnfreeze;
    }

    public Integer getDepositAmount() {
        return depositAmount;
    }

    public void setDepositAmount(Integer depositAmount) {
        this.depositAmount = depositAmount;
    }

    public String getCreditStatus() {
        return creditStatus;
    }

    public void setCreditStatus(String creditStatus) {
        this.creditStatus = creditStatus;
    }

    @Override
    public String getExtra() {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("authNo", authNo);
        jsonObject.put("preAuthAmount", preAuthAmount);
        jsonObject.put("authStatus", authStatus);
        jsonObject.put("freezeAmount", freezeAmount);
        jsonObject.put("authValidTime", authValidTime);
        jsonObject.put("tradeNo", tradeNo);
        jsonObject.put("buyerId", buyerId);
        jsonObject.put("buyerLogonId", buyerLogonId);
        jsonObject.put("aliAppId", aliAppId);
        jsonObject.put("channelMode", channelMode);
        jsonObject.put("gmtAuthSuccess", gmtAuthSuccess);
        jsonObject.put("gmtAuthClose", gmtAuthClose);
        jsonObject.put("gmtAuthUnfreeze", gmtAuthUnfreeze);
        jsonObject.put("depositAmount", depositAmount);
        jsonObject.put("creditStatus", creditStatus);
        return jsonObject.toJSONString();
    }
} 