package cn.com.duiba.paycenter.dto.payment.charge.bankofsuzhou;

import cn.com.duiba.paycenter.dto.payment.charge.BaseChargeRequest;

import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

/**
 * @author zhangruofan
 * @date 2019/06/10
 */
public class BankOfSuZhouWapChargeRequest extends BaseChargeRequest {

    private static final long serialVersionUID = 4820672203639554848L;
    /**
     * 客户端ip
     */
    @Size(max = 16, message = "ip的长度超过16")
    private String ip;

    /**
     * 商品描述
     */
    @Size(max = 255, message = "商品描述超过255")
    @NotNull(message = "商品详情不能为空")
    private String goodsDetail;

    public String getIp() {
        return ip;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public String getGoodsDetail() {
        return goodsDetail;
    }

    public void setGoodsDetail(String goodsDetail) {
        this.goodsDetail = goodsDetail;
    }
}
