package cn.com.duiba.paycenter.dto.payment.charge.cebXyk;

import cn.com.duiba.paycenter.dto.payment.charge.BaseChargeRequest;

import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

/**
 * @author haojiahong
 * @date 2021-01-29
 */
public class CebXykWapChargeRequest extends BaseChargeRequest {

    private static final long serialVersionUID = 2904472479066749526L;

    /**
     * 客户端ip
     */
    @Size(max = 16, message = "ip的长度超过16")
    private String ip;

    /**
     * 商品名称
     */
    @Size(max = 128, message = "商品名称超过128")
    @NotNull(message = "商品名称不能为空")
    private String goodsName;


    /**
     * 商品活动编码，非必填，默认pay-center中的配置
     */
    private String activityCode;

    /**
     * 支付限制时间，单位秒，非必填，默认15分钟
     */
    private Integer validTimeSeconds;

    /**
     * 返回商户链接
     */
    private String backUrl;

    /**
     * 开发者订单列表页，查询详情按钮，跳转链接
     */
    private String detailUrl;

    /**
     * 开发者订单列表页，订单图片，非必填，默认展示兑吧图片
     */
    private String orderImg;

    public String getDetailUrl() {
        return detailUrl;
    }

    public void setDetailUrl(String detailUrl) {
        this.detailUrl = detailUrl;
    }

    public String getOrderImg() {
        return orderImg;
    }

    public void setOrderImg(String orderImg) {
        this.orderImg = orderImg;
    }

    public String getActivityCode() {
        return activityCode;
    }

    public void setActivityCode(String activityCode) {
        this.activityCode = activityCode;
    }

    public String getIp() {
        return ip;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public String getGoodsName() {
        return goodsName;
    }

    public void setGoodsName(String goodsName) {
        this.goodsName = goodsName;
    }

    public Integer getValidTimeSeconds() {
        return validTimeSeconds;
    }

    public void setValidTimeSeconds(Integer validTimeSeconds) {
        this.validTimeSeconds = validTimeSeconds;
    }

    public String getBackUrl() {
        return backUrl;
    }

    public void setBackUrl(String backUrl) {
        this.backUrl = backUrl;
    }
}
