package cn.com.duiba.paycenter.dto.payment.charge.cmb;

import java.io.Serializable;

/**
 * 招商银行-掌上生活-开放平台-H5支付-支付回调
 *
 * @author songp
 * @date 2024/2/19 9:43 上午
 */
public class CmbLifePayNotifyDto implements Serializable {

    private static final long serialVersionUID = 8535820434069399310L;

    /**
     * 合作方订单号
     */
    private String billNo;

    /**
     * 掌上生活确认支付结果的时间，格式yyyyMMddHHmmss
     */
    private String payDate;

    /**
     * 支付结果，2：成功，3：失败
     */
    private String result;

    /**
     * 说明文字/错误信息
     */
    private String message;

    /**
     * 订单金额（单位为分）
     */
    private String amount;

    /**
     * 订单积分
     */
    private String bonus;

    /**
     * 支付方式，从左往右，第一位：招行贷记，第二位：招行借记，第三位：招行外贷记，第四位：招行外借记
     */
    private String payType;

    /**
     * 交易参考号，支付失败时不存在，交易以此对账
     */
    private String refNum;

    /**
     * 屏蔽卡号，积分支付时不存在
     */
    private String shieldCardNo;

    public String getBillNo() {
        return billNo;
    }

    public void setBillNo(String billNo) {
        this.billNo = billNo;
    }

    public String getPayDate() {
        return payDate;
    }

    public void setPayDate(String payDate) {
        this.payDate = payDate;
    }

    public String getResult() {
        return result;
    }

    public void setResult(String result) {
        this.result = result;
    }

    public String getMessage() {
        return message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getAmount() {
        return amount;
    }

    public void setAmount(String amount) {
        this.amount = amount;
    }

    public String getBonus() {
        return bonus;
    }

    public void setBonus(String bonus) {
        this.bonus = bonus;
    }

    public String getPayType() {
        return payType;
    }

    public void setPayType(String payType) {
        this.payType = payType;
    }

    public String getRefNum() {
        return refNum;
    }

    public void setRefNum(String refNum) {
        this.refNum = refNum;
    }

    public String getShieldCardNo() {
        return shieldCardNo;
    }

    public void setShieldCardNo(String shieldCardNo) {
        this.shieldCardNo = shieldCardNo;
    }
}
