package cn.com.duiba.paycenter.dto.payment.charge.cus;

import javax.validation.constraints.Min;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import java.io.Serializable;
import java.util.Date;

/**
 * 62vip 活动支付请求
 *
 * @author fja
 * @date 2022-06-14
 * @see http://cf.dui88.com/pages/viewpage.action?pageId=151134546
 */
public class Activity62VipPayRequestDto implements Serializable {

    @NotNull(message = "appId不能为空")
    private Long appId;

    @NotBlank(message = "商户订单号不能为空")
    @Size(max = 32, message = "商户订单号32字符以内")
    private String outTradeNo;

    @NotBlank(message = "商品描述不能为空")
    private String body;

    @NotBlank(message = "附加信息不能为空")
    private String attach;

    @NotNull(message = "总金额不能为空")
    @Min(value = 1, message = "支付金额为正整数")
    private Integer totalFee;

    @NotBlank(message = "通知地址不能为空")
    private String notifyUrl;

    @NotBlank(message = "商品ID")
    private String productId;

    @NotBlank(message = "订单有效时间")
    private String timeoutExpress;

    @NotNull(message = "下单时间不为空")
    private Date chargeDate;

    @NotBlank(message = "用户ip")
    private String clientIp;

    public Long getAppId() {
        return appId;
    }

    public void setAppId(Long appId) {
        this.appId = appId;
    }

    public String getOutTradeNo() {
        return outTradeNo;
    }

    public void setOutTradeNo(String outTradeNo) {
        this.outTradeNo = outTradeNo;
    }

    public String getBody() {
        return body;
    }

    public void setBody(String body) {
        this.body = body;
    }

    public String getAttach() {
        return attach;
    }

    public void setAttach(String attach) {
        this.attach = attach;
    }

    public Integer getTotalFee() {
        return totalFee;
    }

    public void setTotalFee(Integer totalFee) {
        this.totalFee = totalFee;
    }

    public String getNotifyUrl() {
        return notifyUrl;
    }

    public void setNotifyUrl(String notifyUrl) {
        this.notifyUrl = notifyUrl;
    }

    public String getProductId() {
        return productId;
    }

    public void setProductId(String productId) {
        this.productId = productId;
    }

    public String getTimeoutExpress() {
        return timeoutExpress;
    }

    public void setTimeoutExpress(String timeoutExpress) {
        this.timeoutExpress = timeoutExpress;
    }

    public Date getChargeDate() {
        return chargeDate;
    }

    public void setChargeDate(Date chargeDate) {
        this.chargeDate = chargeDate;
    }

    public String getClientIp() {
        return clientIp;
    }

    public void setClientIp(String clientIp) {
        this.clientIp = clientIp;
    }
}
