package cn.com.duiba.paycenter.dto.payment.charge.cus;

import cn.com.duiba.paycenter.dto.payment.refund.RefundResponse;

import java.io.Serializable;

/**
 * @ClassName YbsRefundOrderRespDto
 * @Description 62vip 退款返回
 * @Author wenYongLei
 * @Date 2022/8/4 16:43
 */
public class YbsRefundOrderResp extends RefundResponse implements Serializable {
    private String version;

    private String charset;

    private String signType;

    private String status;

    private String message;

    private String resultCode;

    private String mchId;

    private String deviceInfo;

    private String nonceStr;

    private String errCode;

    private String errMsg;

    private String sign;

    /**
     * 在 status 和 result_code 都为 0 的时候有返回
     * 商户订单号
     * 商户系统内部的订单号
     */
    private String outTradeNo;

    /**
     *  在 status 和 result_code 都为 0 的时候有返回
     *  商户退款单号
     */
    private String outRefundNo;

    /**
     * 在 status 和 result_code 都为 0 的时候有返回
     * 退款 id
     */
    private String refundId;

    /**
     * 在 status 和 result_code 都为 0 的时候有返回
     * 申请退款金额
     * 退款总金额,单位为分,可以做部分退款
     */
    private String refundFee;

    /**
     * 在 status 和 result_code 都为 0 的时候有返回
     * 退款金额
     *
     * 去掉非充值代金券退款金额后的退款金额， 退款金额=申请退款金额-非充值代金券退款金额， 退款金额<=申请退款金额
     */
    private String settlementRefundFee;

    public String getVersion() {
        return version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getCharset() {
        return charset;
    }

    public void setCharset(String charset) {
        this.charset = charset;
    }

    public String getSignType() {
        return signType;
    }

    public void setSignType(String signType) {
        this.signType = signType;
    }

    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getMessage() {
        return message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getResultCode() {
        return resultCode;
    }

    public void setResultCode(String resultCode) {
        this.resultCode = resultCode;
    }

    public String getMchId() {
        return mchId;
    }

    public void setMchId(String mchId) {
        this.mchId = mchId;
    }

    public String getDeviceInfo() {
        return deviceInfo;
    }

    public void setDeviceInfo(String deviceInfo) {
        this.deviceInfo = deviceInfo;
    }

    public String getNonceStr() {
        return nonceStr;
    }

    public void setNonceStr(String nonceStr) {
        this.nonceStr = nonceStr;
    }

    public String getErrCode() {
        return errCode;
    }

    public void setErrCode(String errCode) {
        this.errCode = errCode;
    }

    public String getErrMsg() {
        return errMsg;
    }

    public void setErrMsg(String errMsg) {
        this.errMsg = errMsg;
    }

    public String getSign() {
        return sign;
    }

    public void setSign(String sign) {
        this.sign = sign;
    }

    public String getOutTradeNo() {
        return outTradeNo;
    }

    public void setOutTradeNo(String outTradeNo) {
        this.outTradeNo = outTradeNo;
    }

    public String getOutRefundNo() {
        return outRefundNo;
    }

    public void setOutRefundNo(String outRefundNo) {
        this.outRefundNo = outRefundNo;
    }

    public String getRefundId() {
        return refundId;
    }

    public void setRefundId(String refundId) {
        this.refundId = refundId;
    }

    public String getRefundFee() {
        return refundFee;
    }

    public void setRefundFee(String refundFee) {
        this.refundFee = refundFee;
    }

    public String getSettlementRefundFee() {
        return settlementRefundFee;
    }

    public void setSettlementRefundFee(String settlementRefundFee) {
        this.settlementRefundFee = settlementRefundFee;
    }
}
