package cn.com.duiba.paycenter.dto.payment.charge.cus;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

/**
 * @ClassName RefundQueryEntity
 * @Description 62vip 退款订单查询
 * @Author wenYongLei
 * @Date 2022/8/26 23:07
 */
public class YbsRefundQueryDto implements Serializable {
    /**
     * 交易订单号
     */
    private String chargeOrderNo;
    /**
     * 支付订单号
     */
    private String bizOrderNo;

    /**
     * 退款订单日期 YYYYMMDD
     */
    @NotBlank(message = "退款订单日期不能为空")
    private String tradeDate;

    public String getTradeDate() {
        return tradeDate;
    }

    public void setTradeDate(String tradeDate) {
        this.tradeDate = tradeDate;
    }


    public String getChargeOrderNo() {
        return chargeOrderNo;
    }

    public void setChargeOrderNo(String chargeOrderNo) {
        this.chargeOrderNo = chargeOrderNo;
    }

    public String getBizOrderNo() {
        return bizOrderNo;
    }

    public void setBizOrderNo(String bizOrderNo) {
        this.bizOrderNo = bizOrderNo;
    }
}
