package cn.com.duiba.paycenter.dto.payment.charge.icbc.elife;

import cn.com.duiba.paycenter.dto.payment.charge.BaseChargeRequest;

import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

/**
 * 工行e生活-支付请求
 *
 * @author songp
 * @date 2024/5/9 3:25 下午
 */
public class IcbcELifeChargeRequest extends BaseChargeRequest {

    private static final long serialVersionUID = 8761721069477341839L;

    /**
     * 交易日期时间 yyyyMMddHHmmss
     */
    @NotNull(message = "交易日期时间不能为空")
    private String orderDate;

    /**
     * 商户代码
     * 唯一确定一个商户的代码，由商户在工行开户时，由工行告知商户。
     */
    private String merID;

    /**
     * 商户账号
     * 商户入账账号，只能交易时指定。
     * （商户付给银行手续费的账户，可以在开户的时候指定，也可以用交易指定方式；
     * 用交易指定方式则使用此商户账号）
     */
    private String merAcct;

    /**
     * 商品编号
     */
    private String goodsID;

    /**
     * 商品名称
     */
    private String goodsName;

    /**
     * 商品数量
     */
    private Integer goodsNum;

    /**
     * 商城提示，选输
     */
    private String merHint;

    /**
     * 通知商户URL
     */
    @NotNull(message = "通知商户URL不能为空")
    private String notifyUrl;

    /**
     * 启动类型
     * 必输，
     * 取值：
     * 1：工行iPhone客户端版
     * 2：工行Android客户端版
     * 21：工行移动生活版（iPhone）
     * 22：工行移动生活版（Android）
     * 0：HTML版（只支持iPhone、Android的webkit核心浏览器）
     */
    private String clientType;

    /**
     * 用户IP
     */
    private String ip;

    public String getClientType() {
        return clientType;
    }

    public void setClientType(String clientType) {
        this.clientType = clientType;
    }

    public String getOrderDate() {
        return orderDate;
    }

    public void setOrderDate(String orderDate) {
        this.orderDate = orderDate;
    }

    public String getMerID() {
        return merID;
    }

    public void setMerID(String merID) {
        this.merID = merID;
    }

    public String getMerAcct() {
        return merAcct;
    }

    public void setMerAcct(String merAcct) {
        this.merAcct = merAcct;
    }

    public String getGoodsID() {
        return goodsID;
    }

    public void setGoodsID(String goodsID) {
        this.goodsID = goodsID;
    }

    public String getGoodsName() {
        return goodsName;
    }

    public void setGoodsName(String goodsName) {
        this.goodsName = goodsName;
    }

    public Integer getGoodsNum() {
        return goodsNum;
    }

    public void setGoodsNum(Integer goodsNum) {
        this.goodsNum = goodsNum;
    }

    public String getNotifyUrl() {
        return notifyUrl;
    }

    public void setNotifyUrl(String notifyUrl) {
        this.notifyUrl = notifyUrl;
    }

    public String getMerHint() {
        return merHint;
    }

    public void setMerHint(String merHint) {
        this.merHint = merHint;
    }

    public String getIp() {
        return ip;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }
}
