package cn.com.duiba.paycenter.dto.payment.charge.wxpay;

import cn.com.duiba.api.enums.SubjectTypeEnum;
import cn.com.duiba.paycenter.enums.RedPacketBizRelationTypeEnum;
import cn.com.duiba.paycenter.enums.ChannelEnum;
import cn.com.duiba.paycenter.validator.ChannelEnumCheck;
import cn.com.duiba.wolf.utils.GZIPUtils;
import com.alibaba.fastjson.JSONObject;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;


/**
 * 微信红包订单请求
 *
 * @author fxr
 * @date 2020/04/10
 */
public class WxPayRedPacketQueryRequest implements Serializable {

    private static final long serialVersionUID = 5816858301756161337L;
    /**
     * 支付渠道
     * @see ChannelEnum#getChannelType()
     */
    @NotBlank(message = "channelType不能为空")
    @ChannelEnumCheck
    private String channelType;

    /**
     * 兑吧appId
     */
    @NotNull(message = "兑吧appId不能为空")
    private Long appId;

    /**
     * 业务主体类型 -- 必传参数
     * @see SubjectTypeEnum#getType()
     */
    @NotBlank(message = "subjectType类型不能为空")
    private String subjectType;

    /**
     * 业务方关联活动类型
     * @see RedPacketBizRelationTypeEnum#getCode()
     */
    @NotNull(message = "bizRelationType不能为空")
    private Integer bizRelationType;

    /**
     * 业务方关联活动id
     */
    @NotBlank(message = "bizRelationId不能为空")
    private String bizRelationId;

    /**
     * 业务方订单号
     */
    @NotBlank(message = "bizOrderNo不能为空")
    private String bizOrderNo;

    /**
     * 订单类型
     * 商户订单号/支付订单号
     * MCHT:通过商户订单号获取红包信息。
     */
    @NotBlank(message = "billType不能为空")
    private String billType;


    public String getChannelType() {
        return channelType;
    }

    public void setChannelType(String channelType) {
        this.channelType = channelType;
    }

    public Long getAppId() {
        return appId;
    }

    public void setAppId(Long appId) {
        this.appId = appId;
    }

    public String getSubjectType() {
        return subjectType;
    }

    public void setSubjectType(String subjectType) {
        this.subjectType = subjectType;
    }

    public String getBillType() {
        return billType;
    }

    public void setBillType(String billType) {
        this.billType = billType;
    }

    public Integer getBizRelationType() {
        return bizRelationType;
    }

    public void setBizRelationType(Integer bizRelationType) {
        this.bizRelationType = bizRelationType;
    }

    public String getBizRelationId() {
        return bizRelationId;
    }

    public void setBizRelationId(String bizRelationId) {
        this.bizRelationId = bizRelationId;
    }

    public String getBizOrderNo() {
        return bizOrderNo;
    }

    public void setBizOrderNo(String bizOrderNo) {
        this.bizOrderNo = bizOrderNo;
    }

    /**
     * 解码消息，接收mq消息使用
     *
     * @param msg
     * @return
     */
    public static WxPayRedPacketQueryRequest decode(byte[] msg) {
        String string = GZIPUtils.ungzip(msg);
        if (string == null || string.isEmpty()) {
            return null;
        }
        return JSONObject.parseObject(string, WxPayRedPacketQueryRequest.class);
    }

    /**
     * 编码消息，发送时使用
     *
     * @param msg
     * @return
     */
    public static byte[] encode(WxPayRedPacketQueryRequest msg) {
        String string = JSONObject.toJSONString(msg);
        return GZIPUtils.gzip(string);
    }
}
