package cn.com.duiba.paycenter.dto.payment.charge.wxpay;

import cn.com.duiba.api.enums.SubjectTypeEnum;
import cn.com.duiba.paycenter.enums.ChannelEnum;
import cn.com.duiba.paycenter.validator.ChannelEnumCheck;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;


/**
 * 微信转账查询请求
 *
 */
public class WxTransferPayQueryRequest implements Serializable {
    private static final long serialVersionUID = 2382780759457492823L;

    /**
     * 支付渠道
     * @see ChannelEnum#getChannelType()
     */
    @NotBlank(message = "channelType不能为空")
    @ChannelEnumCheck
    private String channelType;

    /**
     * 兑吧appId
     */
    @NotNull(message = "兑吧appId不能为空")
    private Long appId;

    /**
     * 业务主体类型 -- 必传参数
     * @see SubjectTypeEnum#getType()
     */
    @NotBlank(message = "subjectType类型不能为空")
    private String subjectType;

    /**
     * 业务方关联活动类型
     * 拆红包一般为31008
     * @see cn.com.duiba.api.enums.ActivityUniformityTypeEnum#getCode()
     */
    @NotNull(message = "bizRelationType不能为空")
    private Integer bizRelationType;

    /**
     * 业务方关联活动id
     * 关联tb_open_red_packet_config表主键（红包活动配置id）
     */
    @NotBlank(message = "bizRelationId不能为空")
    private String bizRelationId;

    /**
     * 业务方订单号
     * 关联tb_cash_draws_record提现记录id
     */
    @NotBlank(message = "bizOrderNo不能为空")
    private String bizOrderNo;

    public String getChannelType() {
        return channelType;
    }

    public void setChannelType(String channelType) {
        this.channelType = channelType;
    }

    public Long getAppId() {
        return appId;
    }

    public void setAppId(Long appId) {
        this.appId = appId;
    }

    public String getSubjectType() {
        return subjectType;
    }

    public void setSubjectType(String subjectType) {
        this.subjectType = subjectType;
    }

    public Integer getBizRelationType() {
        return bizRelationType;
    }

    public void setBizRelationType(Integer bizRelationType) {
        this.bizRelationType = bizRelationType;
    }

    public String getBizRelationId() {
        return bizRelationId;
    }

    public void setBizRelationId(String bizRelationId) {
        this.bizRelationId = bizRelationId;
    }

    public String getBizOrderNo() {
        return bizOrderNo;
    }

    public void setBizOrderNo(String bizOrderNo) {
        this.bizOrderNo = bizOrderNo;
    }
}
