package cn.com.duiba.paycenter.dto.payment.refund.alipay;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import java.io.Serializable;

/**
 * 支付宝预授权解冻请求类
 * 对应支付宝 alipay.fund.auth.order.unfreeze 接口
 * 
 * @author AI Assistant
 * @date 2024/12/19
 */
public class AlipayPreAuthUnfreezeRequest implements Serializable {
    private static final long serialVersionUID = 1L;

    /**
     * 商户本次资金操作的请求流水号
     * 用于标识一次资金操作，需要保证在商户端不重复
     */
    @NotBlank(message = "商户请求流水号不能为空")
    @Size(max = 64, message = "商户请求流水号长度不能超过64")
    private String outRequestNo;

    /**
     * 支付宝授权资金订单号
     * 与商户的授权资金订单号不能同时为空，二者都存在时，以支付宝资金授权订单号为准
     */
    @Size(max = 64, message = "支付宝授权资金订单号长度不能超过64")
    private String authNo;

    /**
     * 商户的授权资金订单号
     * 与支付宝的授权资金订单号不能同时为空，二者都存在时，以支付宝资金授权订单号为准
     */
    @Size(max = 64, message = "商户授权资金订单号长度不能超过64")
    private String outOrderNo;

    /**
     * 本次操作解冻的金额，单位为分
     * 不传则解冻订单剩余全部金额
     */
    private Integer amount;

    /**
     * 解冻原因说明
     */
    @Size(max = 100, message = "解冻原因说明长度不能超过100")
    private String remark;

    /**
     * 商户额外信息
     * 回传给商户的额外信息，可以为空
     */
    @Size(max = 512, message = "商户额外信息长度不能超过512")
    private String extraParam;

    /**
     * 业务主体类型
     * 用于区分不同的业务主体（如兑吧、对接等）
     */
    private String subjectType;


    public String getOutRequestNo() {
        return outRequestNo;
    }

    public void setOutRequestNo(String outRequestNo) {
        this.outRequestNo = outRequestNo;
    }

    public String getAuthNo() {
        return authNo;
    }

    public void setAuthNo(String authNo) {
        this.authNo = authNo;
    }

    public String getOutOrderNo() {
        return outOrderNo;
    }

    public void setOutOrderNo(String outOrderNo) {
        this.outOrderNo = outOrderNo;
    }

    public Integer getAmount() {
        return amount;
    }

    public void setAmount(Integer amount) {
        this.amount = amount;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public String getExtraParam() {
        return extraParam;
    }

    public void setExtraParam(String extraParam) {
        this.extraParam = extraParam;
    }

    public String getSubjectType() {
        return subjectType;
    }

    public void setSubjectType(String subjectType) {
        this.subjectType = subjectType;
    }

} 