/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.paycenter.client;

import cn.com.duiba.paycenter.client.RpcResult;
import cn.com.duiba.paycenter.params.DuibaPayOrdersExtraParams;
import cn.com.duiba.paycenter.result.PayOrdersResult;
import cn.com.duiba.paycenter.service.DuibaPayAccountDrawService;
import cn.com.duiba.paycenter.util.SignUtil;
import com.google.common.collect.Maps;
import java.util.HashMap;

public class DuibaPayAccountDrawServiceClient {
    private DuibaPayAccountDrawService duibaPayAccountDrawService;

    public RpcResult<PayOrdersResult> payOrder(Long orderId, Long money, DuibaPayOrdersExtraParams p) {
        try {
            HashMap params = Maps.newHashMap();
            params.put("orderId", orderId + "");
            params.put("money", money + "");
            String sign = SignUtil.sign(params);
            PayOrdersResult ret = this.duibaPayAccountDrawService.pay(orderId, money, sign, p);
            return new RpcResult<PayOrdersResult>(ret);
        }
        catch (Exception e) {
            return new RpcResult<PayOrdersResult>(e);
        }
    }

    public RpcResult<PayOrdersResult> backPayOrder(Long orderId, Long money) {
        try {
            HashMap params = Maps.newHashMap();
            params.put("orderId", orderId + "");
            params.put("money", money + "");
            String sign = SignUtil.sign(params);
            PayOrdersResult ret = this.duibaPayAccountDrawService.backPay(orderId, money, sign);
            return new RpcResult<PayOrdersResult>(ret);
        }
        catch (Exception e) {
            return new RpcResult<PayOrdersResult>(e);
        }
    }

    public void setDuibaPayAccountDrawService(DuibaPayAccountDrawService duibaPayAccountDrawService) {
        this.duibaPayAccountDrawService = duibaPayAccountDrawService;
    }
}

