/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.permission.client;

import cn.com.duiba.permission.client.common.resource.ResourceTreeCache;
import cn.com.duiba.permission.client.common.resource.ResourceTreeNode;
import cn.com.duiba.permission.client.common.resource.ResourceTreeService;
import cn.com.duiba.permission.client.common.user.UserResourceKey;
import cn.com.duiba.permission.client.common.user.strategy.UserResourceCacheStrategy;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Resource;

public class PermissionClient {
    @Resource
    private UserResourceCacheStrategy userResourceCacheStrategy;
    @Resource
    private ResourceTreeService resourceTreeService;

    public Boolean hasResource(String sheetKey, Long userId, String resourceIndex) {
        return this.hasResource(sheetKey, userId, resourceIndex, false);
    }

    public Boolean hasResource(String sheetKey, Long userId, String resourceIndex, boolean ignoreNotContainsResourceIndex) {
        ResourceTreeCache resourceTreeCache = this.resourceTreeService.findResourceTreeCacheBySheetKey(sheetKey);
        Set<Long> pawerIds = resourceTreeCache.getResourceIdsByIndex(resourceIndex);
        if (pawerIds.isEmpty() && ignoreNotContainsResourceIndex) {
            return true;
        }
        if (pawerIds.isEmpty()) {
            return false;
        }
        UserResourceKey userResourceKey = new UserResourceKey();
        userResourceKey.setUserId(userId);
        userResourceKey.setSheetKey(sheetKey);
        Set<Long> relations = this.userResourceCacheStrategy.findUserResourceCache(userResourceKey);
        return !Sets.intersection(pawerIds, relations).isEmpty();
    }

    public Set<String> findAllUserHasResourceIndex(String sheetKey, Long userId) {
        UserResourceKey userResourceKey = new UserResourceKey();
        userResourceKey.setUserId(userId);
        userResourceKey.setSheetKey(sheetKey);
        Set<Long> relations = this.userResourceCacheStrategy.findUserResourceCache(userResourceKey);
        if (relations.isEmpty()) {
            return Collections.emptySet();
        }
        ResourceTreeCache resourceTreeCache = this.resourceTreeService.findResourceTreeCacheBySheetKey(sheetKey);
        HashSet resourceIndexs = Sets.newHashSet();
        for (Long resourceId : relations) {
            ResourceTreeNode node = resourceTreeCache.getResource(resourceId);
            resourceIndexs.addAll(node.getResourceIndexs());
        }
        return resourceIndexs;
    }
}

