/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.permission.client.common.accesstoken;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.permission.client.PermissionClientProperties;
import cn.com.duiba.permission.client.dto.AccessToken;
import cn.com.duiba.permission.client.params.AccessTokenParams;
import cn.com.duiba.permission.client.remoteservice.RemotePermissionAccessTokenService;
import java.util.Date;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.Scheduled;

public class AccessTokenClient {
    private static final Logger log = LoggerFactory.getLogger(AccessTokenClient.class);
    @Resource
    private RemotePermissionAccessTokenService remotePermissionAccessTokenService;
    @Resource
    private PermissionClientProperties permissionClientProperties;
    private AtomicReference<AccessToken> reference = new AtomicReference();

    public String getAccessToken() {
        AccessToken accessToken = this.reference.get();
        if (Objects.nonNull(accessToken)) {
            return accessToken.getAccessToken();
        }
        return this.loadAccessToken().getAccessToken();
    }

    @Scheduled(cron="0 0 0/1 * * ?")
    public void reflushAccessToken() {
        try {
            AccessToken accessToken = this.reference.get();
            if (Objects.isNull(accessToken) || new Date().after(accessToken.getExpirationTime())) {
                this.reference.set(null);
                return;
            }
            this.reference.set(this.remotePermissionAccessTokenService.updateAccessToken(accessToken.getUpdateToken()));
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6accessToken\u5931\u8d25", (Throwable)e);
        }
    }

    private synchronized AccessToken loadAccessToken() {
        try {
            AccessToken accessToken = this.reference.get();
            if (Objects.nonNull(accessToken) && new Date().before(accessToken.getExpirationTime())) {
                return accessToken;
            }
            AccessTokenParams params = new AccessTokenParams();
            params.setTenementKey(this.permissionClientProperties.getTenementKey());
            params.setTenementSecret(this.permissionClientProperties.getTenementSecret());
            params.setInstanceId(this.permissionClientProperties.getInstanceId());
            AccessToken newAccessToken = this.remotePermissionAccessTokenService.findAccessToken(params);
            if (StringUtils.isBlank((String)newAccessToken.getAccessToken())) {
                throw new RuntimeException("\u672a\u80fd\u6b63\u5e38\u83b7\u53d6AccessToken");
            }
            this.reference.set(newAccessToken);
            return newAccessToken;
        }
        catch (BizException e) {
            throw new RuntimeException(e);
        }
    }
}

