/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.permission.client.common.resource;

import cn.com.duiba.permission.client.common.resource.ResourceTreeNode;
import cn.com.duiba.permission.client.common.tree.Tree;
import cn.com.duiba.permission.client.common.tree.TreeBuilder;
import cn.com.duiba.permission.client.common.tree.TreeView;
import com.google.common.collect.HashMultimap;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import org.apache.commons.lang.StringUtils;

public class ResourceTreeCache {
    private Tree<ResourceTreeNode> resourceTree;
    private HashMultimap<String, Long> resourceIndexs;

    ResourceTreeCache(Tree<ResourceTreeNode> resourceTree, HashMultimap<String, Long> resourceIndexs) {
        this.resourceTree = resourceTree;
        this.resourceIndexs = resourceIndexs;
    }

    ResourceTreeCache() {
        this.resourceTree = TreeBuilder.createTree(Collections.emptyList());
    }

    public Set<Long> getResourceIdsByIndex(String resourceIndex) {
        if (StringUtils.isBlank((String)resourceIndex)) {
            return Collections.emptySet();
        }
        return this.resourceIndexs.get((Object)resourceIndex);
    }

    public ResourceTreeNode getResource(Long resourceId) {
        return this.resourceTree.getNode(resourceId);
    }

    public <T extends TreeView<T>> List<T> getResourceTree(Function<ResourceTreeNode, T> transform) {
        return this.resourceTree.transformTreeView(transform);
    }

    public List<ResourceTreeNode> getResourceWay(Long powerId) {
        return this.resourceTree.getOneWayView(powerId);
    }
}

