/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.permission.client.common.resource;

import cn.com.duiba.application.boot.stream.annotation.StreamListener;
import cn.com.duiba.permission.client.PermissionClientProperties;
import cn.com.duiba.permission.client.common.accesstoken.AccessTokenClient;
import cn.com.duiba.permission.client.common.resource.ResourceTreeCache;
import cn.com.duiba.permission.client.common.resource.ResourceTreeNode;
import cn.com.duiba.permission.client.common.resource.ResourceUpdateEvent;
import cn.com.duiba.permission.client.common.resource.resolver.ResourceIndexResolver;
import cn.com.duiba.permission.client.common.tree.Tree;
import cn.com.duiba.permission.client.common.tree.TreeBuilder;
import cn.com.duiba.permission.client.dto.ResourceDto;
import cn.com.duiba.permission.client.remoteservice.RemoteResourceApiService;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class ResourceTreeService {
    private static final Logger log = LoggerFactory.getLogger(ResourceTreeService.class);
    private Map<String, ResourceIndexResolver> resolverMap = Maps.newHashMap();
    @Resource
    private RemoteResourceApiService remoteResourceApiService;
    @Resource
    private AccessTokenClient accessTokenClient;
    @Resource
    private PermissionClientProperties permissionClientProperties;
    private LoadingCache<String, ResourceTreeCache> treeCache = Caffeine.newBuilder().expireAfterWrite(1L, TimeUnit.HOURS).build(sheetKey -> {
        String accessToken = this.accessTokenClient.getAccessToken();
        List<ResourceDto> resources = this.remoteResourceApiService.findAllResources(accessToken, (String)sheetKey);
        HashMultimap resourceIndexs = HashMultimap.create();
        ArrayList nodes = Lists.newArrayList();
        for (ResourceDto resource : resources) {
            ResourceIndexResolver resolver = this.resolverMap.get(resource.getType());
            if (Objects.isNull(resolver)) {
                log.warn("\u8d44\u6e90\u5206\u7247[" + sheetKey + "]\u65e0\u6cd5\u89e3\u6790\u7684\u8d44\u6e90\u7c7b\u578b:" + resource.getType());
                continue;
            }
            Set<String> resourceIndex = resolver.doResolver(resource.getContext());
            resourceIndex.remove("$$empet-Index");
            for (String index : resourceIndex) {
                resourceIndexs.put((Object)index, (Object)resource.getId());
            }
            ResourceTreeNode node = new ResourceTreeNode();
            node.setId(resource.getId());
            node.setParentId(resource.getParentId());
            node.setName(resource.getName());
            node.setContext(resource.getContext());
            node.setResourceIndexs(resourceIndex);
            nodes.add(node);
        }
        Tree<ResourceTreeNode> tree = TreeBuilder.createTree(nodes);
        return new ResourceTreeCache(tree, (HashMultimap<String, Long>)resourceIndexs);
    });

    public ResourceTreeCache findResourceTreeCacheBySheetKey(String sheetKey) {
        return (ResourceTreeCache)this.treeCache.get((Object)sheetKey);
    }

    @Autowired
    public void setResolvers(List<ResourceIndexResolver> resolvers) {
        for (ResourceIndexResolver resolver : resolvers) {
            this.resolverMap.put(resolver.supportType(), resolver);
        }
    }

    @StreamListener(value="permission")
    public void acceptResourceUpdateEvent(ResourceUpdateEvent event) {
        if (!StringUtils.equals((String)event.getTenementKey(), (String)this.permissionClientProperties.getTenementKey())) {
            return;
        }
        String accessToken = this.accessTokenClient.getAccessToken();
        Long version = this.remoteResourceApiService.findResourceTreeVersion(accessToken, event.getSheetKey());
        if (event.getVersion() < version) {
            return;
        }
        log.debug("\u6743\u9650\u5206\u7247" + event.getSheetKey() + "\u53d1\u751f\u66f4\u65b0");
        this.treeCache.invalidate((Object)event.getSheetKey());
    }
}

