/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.permission.client.common.tree;

import cn.com.duiba.permission.client.common.tree.TreeNode;
import cn.com.duiba.permission.client.common.tree.TreeNodeShim;
import cn.com.duiba.permission.client.common.tree.TreeView;
import cn.com.duiba.permission.client.exception.PermissionSystemException;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Stack;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Function;
import java.util.stream.Collectors;

public class Tree<T extends TreeNodeShim>
implements Serializable {
    private TreeNode rootNode;
    private Map<Long, T> objMap = Maps.newHashMap();
    private transient ReadWriteLock readWriteLock = new ReentrantReadWriteLock();

    Tree(Long rootId) {
        this.rootNode = new TreeNode(rootId, TreeNode.VIRTUAL_PARENT_ID);
    }

    public boolean containsId(Long id) {
        return this.rootNode.containsId(id);
    }

    public int size() {
        return this.rootNode.getChildSize();
    }

    public void addNode(T shim) {
        try {
            this.readWriteLock.writeLock().lock();
            TreeNode node = new TreeNode((TreeNodeShim)shim);
            this.rootNode.addChildNode(node);
            ((TreeNodeShim)shim).setLevel(node.getLevel());
            this.objMap.put(((TreeNodeShim)shim).getId(), shim);
        }
        finally {
            this.readWriteLock.writeLock().unlock();
        }
    }

    public void deleteNode(Long nodeId) throws Exception {
        try {
            this.readWriteLock.writeLock().lock();
            if (this.rootNode.containsId(nodeId)) {
                this.rootNode.deleteChildNode(nodeId);
                this.objMap.remove(nodeId);
            }
        }
        catch (Exception e) {
            throw new PermissionSystemException(e);
        }
        finally {
            this.readWriteLock.writeLock().unlock();
        }
    }

    public List<T> getTreeView() {
        try {
            this.readWriteLock.readLock().lock();
            List<TreeNode> list = this.rootNode.getAllNode();
            List list2 = list.stream().map(node -> (TreeNodeShim)this.objMap.get(node.getId())).collect(Collectors.toList());
            return list2;
        }
        finally {
            this.readWriteLock.readLock().unlock();
        }
    }

    public T getNode(Long nodeId) {
        return (T)((TreeNodeShim)this.objMap.get(nodeId));
    }

    public List<T> getOneWayView(Long destNodeId) {
        ArrayList idSequence = Lists.newArrayList();
        this.rootNode.findNodeWay(destNodeId, idSequence);
        return idSequence.stream().map(id -> (TreeNodeShim)this.objMap.get(id)).collect(Collectors.toList());
    }

    public <VIEW extends TreeView> List<VIEW> transformTreeView(Function<T, VIEW> transform) {
        if (this.size() == 0) {
            return Collections.emptyList();
        }
        ArrayList viewList = Lists.newArrayList();
        List<T> list = this.getTreeView();
        Stack<TreeView> stack = new Stack<TreeView>();
        for (TreeNodeShim node : list) {
            TreeView item = (TreeView)transform.apply(node);
            Objects.requireNonNull(item.getId());
            Objects.requireNonNull(item.getParentId());
            Objects.requireNonNull(item.getChild());
            if (stack.isEmpty() && item.getLevel() == 1) {
                stack.push(item);
                viewList.add(item);
                continue;
            }
            TreeView top = (TreeView)stack.peek();
            long levelDifference = top.getLevel() - item.getLevel();
            int i = 0;
            while ((long)i <= levelDifference) {
                stack.pop();
                ++i;
            }
            if (stack.isEmpty()) {
                viewList.add(item);
            } else {
                TreeView peek = (TreeView)stack.peek();
                peek.addChild(item);
            }
            stack.push(item);
        }
        return viewList;
    }
}

