/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.permission.client.common.user;

import cn.com.duiba.permission.client.common.user.UserResourceRelationCacheLoader;
import cn.com.duiba.permission.client.common.user.UserResourceUpdateEventAccepter;
import cn.com.duiba.permission.client.common.user.strategy.CaffeineUserResourceCacheStrategy;
import cn.com.duiba.permission.client.common.user.strategy.RedisUserResourceCacheStrategy;
import cn.com.duiba.permission.client.common.user.strategy.RedisUserResourceCacheStrategyProperties;
import cn.com.duiba.permission.client.common.user.strategy.UserResourceCacheStrategy;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class PermissionUserResourceConfiguration {
    @Bean
    public UserResourceRelationCacheLoader userResourceRelationCacheLoader() {
        return new UserResourceRelationCacheLoader();
    }

    @Bean
    @ConditionalOnMissingBean
    public UserResourceCacheStrategy userResourceCacheStrategy() {
        return new CaffeineUserResourceCacheStrategy();
    }

    @Bean
    public UserResourceUpdateEventAccepter userResourceUpdateEventAccepter() {
        return new UserResourceUpdateEventAccepter();
    }

    @Configuration
    @ConditionalOnProperty(prefix="permission.client", name={"cache-strategy"}, havingValue="REDIS")
    @EnableConfigurationProperties(value={RedisUserResourceCacheStrategyProperties.class})
    public static class RedisUserResourceCacheStrategyConfiguration {
        @Bean
        @ConditionalOnMissingBean
        public UserResourceCacheStrategy userResourceCacheStrategy() {
            return new RedisUserResourceCacheStrategy();
        }
    }
}

