/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.permission.client.common.user;

import cn.com.duiba.application.boot.stream.annotation.StreamListener;
import cn.com.duiba.permission.client.PermissionClientProperties;
import cn.com.duiba.permission.client.common.user.UserResourceKey;
import cn.com.duiba.permission.client.common.user.UserResourceUpdateEvent;
import cn.com.duiba.permission.client.common.user.strategy.UserResourceCacheStrategy;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;

public class UserResourceUpdateEventAccepter {
    @Resource
    private PermissionClientProperties permissionClientProperties;
    @Resource
    private UserResourceCacheStrategy userResourceCacheStrategy;

    @StreamListener(value="permissionUser")
    public void acceptUserResourceUpdateEvent(UserResourceUpdateEvent event) {
        if (!StringUtils.equals((String)event.getTenementKey(), (String)this.permissionClientProperties.getTenementKey())) {
            return;
        }
        Boolean updateAllSheet = Optional.ofNullable(event.getUpdateAllSheet()).orElse(false);
        if (updateAllSheet.booleanValue()) {
            this.userResourceCacheStrategy.flashAllSheet(event.getSheetKey());
            return;
        }
        if (Objects.isNull(event.getUserId())) {
            return;
        }
        UserResourceKey key = new UserResourceKey();
        key.setUserId(event.getUserId());
        key.setSheetKey(event.getSheetKey());
        this.userResourceCacheStrategy.cleanUserResourceCache(key);
    }
}

