/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.permission.client.common.user.strategy;

import cn.com.duiba.permission.client.common.user.UserResourceKey;
import cn.com.duiba.permission.client.common.user.UserResourceRelationCacheLoader;
import cn.com.duiba.permission.client.common.user.strategy.UserResourceCacheStrategy;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;

public class CaffeineUserResourceCacheStrategy
implements UserResourceCacheStrategy {
    private LoadingCache<UserResourceKey, Set<Long>> userResourceCache;
    @Resource
    protected UserResourceRelationCacheLoader userResourceRelationCacheLoader;

    @PostConstruct
    public void init() {
        this.userResourceCache = Caffeine.newBuilder().expireAfterWrite(30L, TimeUnit.MINUTES).build(this.userResourceRelationCacheLoader::load);
    }

    @Override
    public Set<Long> findUserResourceCache(UserResourceKey key) {
        return (Set)this.userResourceCache.get((Object)key);
    }

    @Override
    public void cleanUserResourceCache(UserResourceKey key) {
        this.userResourceCache.invalidate((Object)key);
    }

    @Override
    public void flashAllSheet(String sheetKey) {
        Set keys = this.userResourceCache.asMap().keySet();
        for (UserResourceKey key : keys) {
            if (!StringUtils.equals((String)key.getSheetKey(), (String)sheetKey)) continue;
            this.userResourceCache.invalidate((Object)key);
        }
    }
}

