/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.permission.client.common.user.strategy;

import cn.com.duiba.permission.client.PermissionClientProperties;
import cn.com.duiba.permission.client.common.user.UserResourceKey;
import cn.com.duiba.permission.client.common.user.UserResourceRelationCacheLoader;
import cn.com.duiba.permission.client.common.user.strategy.RedisUserResourceCacheStrategyProperties;
import cn.com.duiba.permission.client.common.user.strategy.UserResourceCacheStrategy;
import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.springframework.context.ApplicationContext;
import org.springframework.data.redis.core.BoundHashOperations;
import org.springframework.data.redis.core.StringRedisTemplate;

public class RedisUserResourceCacheStrategy
implements UserResourceCacheStrategy {
    private StringRedisTemplate stringRedisTemplate;
    @Resource
    private RedisUserResourceCacheStrategyProperties redisUserResourceCacheStrategyProperties;
    @Resource
    private ApplicationContext applicationContext;
    @Resource
    private UserResourceRelationCacheLoader userResourceRelationCacheLoader;
    @Resource
    private PermissionClientProperties permissionClientProperties;
    private Splitter splitter = Splitter.on((String)",").omitEmptyStrings().trimResults();
    private Joiner joiner = Joiner.on((String)",").skipNulls();

    @PostConstruct
    public void init() {
        String beanName = this.redisUserResourceCacheStrategyProperties.getBeanName();
        if (!this.applicationContext.containsBean(beanName)) {
            throw new RuntimeException("Spring\u5bb9\u5668\u4e2d\u6ca1\u6709Bean:" + beanName);
        }
        this.stringRedisTemplate = (StringRedisTemplate)this.applicationContext.getBean(beanName, StringRedisTemplate.class);
    }

    @Override
    public Set<Long> findUserResourceCache(UserResourceKey key) {
        String redisKey = this.buildUserResourceRedisKey(key);
        BoundHashOperations operations = this.stringRedisTemplate.boundHashOps((Object)redisKey);
        String resourceIds = (String)operations.get((Object)key.getUserId().toString());
        if (StringUtils.isBlank((String)resourceIds)) {
            return this.loadUserResourceRelation(key);
        }
        if (StringUtils.equals((String)resourceIds, (String)"$$empet-Index")) {
            return Collections.emptySet();
        }
        return this.splitter.splitToList((CharSequence)resourceIds).stream().map(Long::valueOf).collect(Collectors.toSet());
    }

    @Override
    public void cleanUserResourceCache(UserResourceKey key) {
        String redisKey = this.buildUserResourceRedisKey(key);
        if (!this.stringRedisTemplate.hasKey((Object)redisKey).booleanValue()) {
            return;
        }
        this.loadUserResourceRelation(key);
    }

    @Override
    public void flashAllSheet(String sheetKey) {
    }

    private Set<Long> loadUserResourceRelation(UserResourceKey key) {
        String redisKey = this.buildUserResourceRedisKey(key);
        Set<Long> resourceIds = this.userResourceRelationCacheLoader.load(key);
        HashSet resourceStringIds = Sets.newHashSet();
        for (Long resourceId : resourceIds) {
            resourceStringIds.add(resourceId.toString());
        }
        BoundHashOperations operations = this.stringRedisTemplate.boundHashOps((Object)redisKey);
        if (resourceStringIds.isEmpty()) {
            operations.put((Object)key.getUserId().toString(), (Object)"$$empet-Index");
        } else {
            operations.put((Object)key.getUserId().toString(), (Object)this.joiner.join((Iterable)resourceStringIds));
        }
        return resourceIds;
    }

    private String buildUserResourceRedisKey(UserResourceKey key) {
        return "PERMISSION_CLIENT_USER_CACHE:" + this.permissionClientProperties.getTenementKey() + ":" + key.getSheetKey();
    }
}

