/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.permission.client.integration.aop;

import cn.com.duiba.permission.client.PermissionClient;
import cn.com.duiba.permission.client.exception.PermissionSystemException;
import cn.com.duiba.permission.client.integration.aop.ResourceVerify;
import cn.com.duiba.permission.client.integration.user.UserInfoBridge;
import java.lang.reflect.Method;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.expression.BeanFactoryResolver;
import org.springframework.core.LocalVariableTableParameterNameDiscoverer;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.expression.BeanResolver;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.ExpressionParser;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;

@Aspect
public class PermissionClientAspect {
    @Resource
    private UserInfoBridge userInfoBridge;
    @Resource
    private PermissionClient permissionClient;
    @Resource
    private ApplicationContext applicationContext;
    private ExpressionParser parser = new SpelExpressionParser();
    private LocalVariableTableParameterNameDiscoverer discoverer = new LocalVariableTableParameterNameDiscoverer();

    @Around(value="@annotation(ResourceVerify)")
    public Object requireAdvice(ProceedingJoinPoint point) throws Throwable {
        Long userId = this.userInfoBridge.getCurrentUserId();
        if (Objects.isNull(userId)) {
            throw new PermissionSystemException("\u65e0\u6cd5\u83b7\u53d6\u7528\u6237id,\u8bf7\u786e\u8ba4\u5f53\u524d\u7ebf\u7a0b\u662f\u5426\u4e3a\u7528\u6237\u7ebf\u7a0b,\u6216\u8005\u786e\u8ba4\u7528\u6237id\u662f\u5426\u6ce8\u5165UserInfoBridge");
        }
        MethodSignature signature = (MethodSignature)point.getSignature();
        Method method = signature.getMethod();
        ResourceVerify resourceVerify = (ResourceVerify)AnnotationUtils.findAnnotation((Method)method, ResourceVerify.class);
        String sheetKey = resourceVerify.sheetKey();
        if (StringUtils.isBlank((String)sheetKey)) {
            throw new PermissionSystemException("\u8bf7\u6307\u5b9a\u6743\u9650\u6240\u5728\u5206\u7247\u7684Key(sheetKey)");
        }
        String resourceIndex = this.findResourceIndex(point, method, resourceVerify);
        if (StringUtils.isBlank((String)resourceIndex)) {
            return point.proceed();
        }
        Boolean hasPermission = this.permissionClient.hasResource(sheetKey, userId, resourceIndex);
        if (!hasPermission.booleanValue()) {
            throw new PermissionSystemException(resourceVerify.message());
        }
        return point.proceed();
    }

    private String findResourceIndex(ProceedingJoinPoint point, Method method, ResourceVerify resourceVerify) {
        String resourceIndex = resourceVerify.resourceIndex();
        if (StringUtils.isNotBlank((String)resourceIndex)) {
            return resourceIndex;
        }
        String resourceIndexEL = resourceVerify.resourceIndexEL();
        if (StringUtils.isBlank((String)resourceIndexEL)) {
            return "";
        }
        Object[] arguments = point.getArgs();
        String[] paramNames = this.discoverer.getParameterNames(method);
        Expression expression = this.parser.parseExpression(resourceIndexEL);
        StandardEvaluationContext context = new StandardEvaluationContext();
        for (int i = 0; i < arguments.length; ++i) {
            context.setVariable(paramNames[i], arguments[i]);
        }
        context.setBeanResolver((BeanResolver)new BeanFactoryResolver((BeanFactory)this.applicationContext));
        return (String)expression.getValue((EvaluationContext)context, String.class);
    }
}

