/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.permission.client.integration.web;

import cn.com.duiba.permission.client.PermissionClient;
import cn.com.duiba.permission.client.exception.PermissionSystemException;
import cn.com.duiba.permission.client.integration.user.UserInfoBridge;
import java.util.Objects;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

public class PermissionClientInterceptor
extends HandlerInterceptorAdapter {
    private String sheetKey;
    @Resource
    private UserInfoBridge userInfoBridge;
    @Resource
    private PermissionClient permissionClient;

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        if (StringUtils.isBlank((String)this.sheetKey)) {
            return true;
        }
        Long userId = this.userInfoBridge.getCurrentUserId();
        if (Objects.isNull(userId)) {
            throw new PermissionSystemException("\u5f53\u524d\u8bf7\u6c42\u672a\u80fd\u83b7\u53d6\u5230userId");
        }
        String uri = request.getRequestURI();
        Boolean hasPermission = this.permissionClient.hasResource(this.sheetKey, userId, uri, true);
        if (!hasPermission.booleanValue()) {
            throw new PermissionSystemException("\u65e0\u6743\u8bbf\u95ee");
        }
        return true;
    }

    public String getSheetKey() {
        return this.sheetKey;
    }

    public void setSheetKey(String sheetKey) {
        this.sheetKey = sheetKey;
    }
}

