package cn.com.duiba.plugin.center.api.remoteservice.order;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.api.bo.mq.MqDataParam;
import cn.com.duiba.plugin.center.api.dto.ActivityOrderDto;
import cn.com.duiba.plugin.center.api.request.PlaceOrderRequest;
import cn.com.duiba.plugin.center.api.response.PlaceOrderResponse;

import java.util.List;


/**
 * ClassName:RemoteActivityOrderService<br/>
 *
 * @author gey
 * @version 1.0
 * @Description: 插件订单 服务
 * @date 创建时间：2018/5/9  15:28
 * @since JDK 1.8
 **/
@AdvancedFeignClient
public interface RemoteActivityOrderService {
    /**
     * 创建活动订单
     * @param orderDto
     * @return
     */
    String createOrder(ActivityOrderDto orderDto) throws BizException;

    /**
     * 创建活动订单 并且通知奖品中心发放奖品
     * @param mqDataParam
     * @return
     */
    String createOrderAndTakePrizeApi(MqDataParam mqDataParam) throws BizException;

    /**
     * 查询订单信息
     * @param orderNum
     * @return
     */
    ActivityOrderDto findByOrderNum(String orderNum) throws BizException;

    PlaceOrderResponse placeOrder(PlaceOrderRequest request) throws BizException;

    /**
     * 订单批量置为未领奖过期
     * @param orderNums
     * @return
     */
    List<String> exchangeStatusToOverdueBatch(List<String> orderNums);

    /**
     * 用户时间范围参与兑吧活动订单明细
     * @param consumerId
     * @param duibaActivityId
     * @param activityType
     * @param start
     * @param end
     * @return
     */
    ActivityOrderDto findConsumerDuibaActivity4day(long consumerId, Long duibaActivityId, String activityType, String start, String end);

    /**
     * 根据过期时间查询未领奖的活动订单号集合
     * @param expirationTime 过期时间
     * @param activityType 活动类型
     * @return orderNum队列
     */
    List<String> findByExpirationTime(String expirationTime, String activityType);

}
