package cn.com.duiba.plugin.center.api.response;

import java.io.Serializable;

/**
 * Created by hww on 2018/9/30 下午4:23.
 */
public class PlaceOrderResponse implements Serializable {

    private static final long serialVersionUID = 4142319127981706202L;

    /** 子订单id 查询中奖信息唯一凭着 */
    private String orderNum;
    /** 错误信息 下单失败返回 */
    private String errorMsg;

    public static PlaceOrderResponse success(String orderNum) {
        return new PlaceOrderResponse(orderNum, null);
    }

    public static PlaceOrderResponse fail(String errorMsg) {
        return new PlaceOrderResponse(null, errorMsg);
    }

    private PlaceOrderResponse(String orderNum, String errorMsg) {
        this.orderNum = orderNum;
        this.errorMsg = errorMsg;
    }

    public boolean isSuccess() {
        return errorMsg == null;
    }

    public String getOrderNum() {
        return orderNum;
    }

    public void setOrderNum(String orderNum) {
        this.orderNum = orderNum;
    }

    public String getErrorMsg() {
        return errorMsg;
    }

    public void setErrorMsg(String errorMsg) {
        this.errorMsg = errorMsg;
    }
}
