package cn.com.duiba.plugin.center.api.remoteservice.plugin;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.plugin.center.api.request.credits.SubCreditsRequest;
import cn.com.duiba.plugin.center.api.response.CreditsPluginAnswerResponse;
import cn.com.duiba.plugin.center.api.response.CreditsPluginResponse;

/**
 * 积分服务 插件工具
 * 支持扣积分 加积分操作
 * Created by hww on 2019/3/20 10:56.
 */
@AdvancedFeignClient
public interface RemoteCreditsPluginService {

    /**
     * 扣积分服务
     * @param request
     * @return
     */
    CreditsPluginResponse subCredits(SubCreditsRequest request);

    /**
     * 查询扣积分结果
     * @param orderNum
     * @return
     */
    CreditsPluginAnswerResponse queryAnswer(String orderNum);

    /**
     * 将扣积分最终结果同时开发者
     * @param orderNum
     * @param finalResult
     */
    void notifyDeveloper(String orderNum, boolean finalResult);

}
