package cn.com.duiba.plugin.center.api.request;

import cn.com.duiba.api.enums.prize.PrizeRelTypeEnum;
import cn.com.duiba.biz.tool.duiba.dto.RequestParams;

import java.io.Serializable;

/**
 * 独立奖品池发奖请求类
 * Created by xiaoxuda on 2019/3/19
 */
public class IndependentPrizeRequest implements Serializable {

    private static final long serialVersionUID = 4839187979534321196L;

    /** 应用id 必传 */
    private Long appId;
    /** 兑吧用户id 必传 */
    private Long consumerId;
    /** 开发者用户id 必传 */
    private String partnerUserId;
    /** 活动id 必传 */
    private Long activityId;
    /** 活动标题  非必传 */
    private String activityTitle;
    /** 活动类型 必传 */
    private PrizeRelTypeEnum activityType;
    /** RequestParams.parse()方法解析request  必传 */
    private RequestParams requestParams;
    /** 活动消耗积分数  只做记录用  非必传 */
    private Long credits;

    public Long getAppId() {
        return appId;
    }

    public void setAppId(Long appId) {
        this.appId = appId;
    }

    public Long getConsumerId() {
        return consumerId;
    }

    public void setConsumerId(Long consumerId) {
        this.consumerId = consumerId;
    }

    public String getPartnerUserId() {
        return partnerUserId;
    }

    public void setPartnerUserId(String partnerUserId) {
        this.partnerUserId = partnerUserId;
    }

    public Long getActivityId() {
        return activityId;
    }

    public void setActivityId(Long activityId) {
        this.activityId = activityId;
    }

    public String getActivityTitle() {
        return activityTitle;
    }

    public void setActivityTitle(String activityTitle) {
        this.activityTitle = activityTitle;
    }

    public PrizeRelTypeEnum getActivityType() {
        return activityType;
    }

    public void setActivityType(PrizeRelTypeEnum activityType) {
        this.activityType = activityType;
    }

    public RequestParams getRequestParams() {
        return requestParams;
    }

    public void setRequestParams(RequestParams requestParams) {
        this.requestParams = requestParams;
    }

    public Long getCredits() {
        return credits;
    }

    public void setCredits(Long credits) {
        this.credits = credits;
    }

}
