package cn.com.duiba.plugin.center.api.response;

import cn.com.duiba.api.enums.ActivityOrderStutsEnum;

import java.io.Serializable;

/**
 * 积分服务回调结果类
 * Created by hww on 2019/3/22 14:41.
 */
public class CreditsPluginAnswerResponse implements Serializable {

    private static final long serialVersionUID = 5867726116524569768L;

    /**
     * 积分服务结果 result必定有返回值
     * @see ActivityOrderStutsEnum#CONSUME_CREDITS_PROCESSING  处理中  result = 1
     * @see ActivityOrderStutsEnum#CONSUME_CREDITS_FAIL        失败    result = 3
     * @see ActivityOrderStutsEnum#CONSUME_CREDITS_SUCCESS     成功    result = 2
     *
     * 其他未知情况 result = 0;
     */
    private int result;
    /**
     * 失败原因,错误原因
     */
    private String errorMsg;

    private CreditsPluginAnswerResponse() {
        // 防止result字段错误 只能通过静态方法创建对象
    }

    private CreditsPluginAnswerResponse(int result, String errorMsg) {
        this.errorMsg = errorMsg;
        this.result = result;
    }

    public static CreditsPluginAnswerResponse success() {
        // 扣积分和加积分的状态枚举值 code是一致的
        return new CreditsPluginAnswerResponse(ActivityOrderStutsEnum.CONSUME_CREDITS_SUCCESS.getCode(), null);
    }

    public static CreditsPluginAnswerResponse successNotify() {
        return new CreditsPluginAnswerResponse(ActivityOrderStutsEnum.CONSUME_CREDITS_NOTIFY.getCode(), null);
    }

    public static CreditsPluginAnswerResponse fail(String errorMsg) {
        return new CreditsPluginAnswerResponse(ActivityOrderStutsEnum.CONSUME_CREDITS_FAIL.getCode(), errorMsg);
    }

    public static CreditsPluginAnswerResponse processing() {
        return new CreditsPluginAnswerResponse(ActivityOrderStutsEnum.CONSUME_CREDITS_PROCESSING.getCode(), null);
    }

    public static CreditsPluginAnswerResponse error(String errorMsg) {
        return new CreditsPluginAnswerResponse(0, errorMsg);
    }

    public Integer getResult() {
        return result;
    }

    public void setResult(Integer result) {
        this.result = result;
    }

    public String getErrorMsg() {
        return errorMsg;
    }

    public void setErrorMsg(String errorMsg) {
        this.errorMsg = errorMsg;
    }
}
