/**
 * Project Name:activity-center-api
 * File Name:ActivityPrizeOptionDto.java
 * Package Name:cn.com.duiba.activity.center.api.dto.prize
 * Date:2016年7月26日上午10:54:48
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 *
*/

package cn.com.duiba.prize.center.api.dto.prize;

import cn.com.duiba.api.enums.ItemTypeEnums;

import java.io.Serializable;
import java.util.Date;

/**
 * ClassName:ActivityPrizeOptionDto <br/>
 * Date:     2016年7月26日 上午10:54:48 <br/>
 * @author   zp
 * @version  
 * @since    JDK 1.6
 * @see 	 
 */
public class ActivityPrizeOptionDto implements Serializable{

    private static final long serialVersionUID = -2901300513018885255L;
    
    public static final String Activity_Type_Rob = "rob";//今日必抢
    public static final String Activity_Type_Plugin = "plugin";//插件活动
    public static final String Activity_Type_Sign = "sign";//签到活动
    public static final String Activity_Type_Credit_Game = "creditgame";//积分游戏
    public static final String Activity_Type_Little_Game = "littlegame";//小游戏

    public static final String Special_Activity_Type_gift = "gift";//礼包（礼包信息存此表，但礼包其实不是活动类型，也不属于某个活动）
    
    public static final String Prize_Type_Thanks = "thanks";//谢谢参与
    
    public static final String PrizeTypeVirtual = ItemTypeEnums.TypeVirtual.getName(); // 虚拟商品
	public static final String PrizeTypeAlipay = ItemTypeEnums.TypeAlipay.getName(); // 支付宝
	public static final String PrizeTypeQB = ItemTypeEnums.TypeQB.getName(); // QB
	public static final String PrizeTypeCoupon = ItemTypeEnums.TypeCoupon.getName(); // 优惠劵
	public static final String PrizeTypeObject = ItemTypeEnums.TypeObject.getName(); // 实物
	public static final String PrizeTypePhonebill = ItemTypeEnums.TypePhonebill.getName(); // 话费
	public static final String PrizeTypeLuckBag = "lucky";//福袋lucky

    private Long id;
    private Long activityId;//活动id
    private String activityType;//活动类型
    private Long appItemId;//开发者商品ID
    private Long itemId;//兑吧商品ID
    private Long gId;//商品中心ID
    private String gType;//商品中心类型
    private String prizeType;//奖项类型，同ItemDO.Type
    private String prizeName;//奖项名称
    private String facePrice;//面额
    private Long stockId;//库存中心库存ID
    private String rate;//概率
    private String description;//奖项描述
    private Integer payload;//排序
    private Integer hidden;//是否隐藏
    private Integer minComein;//保底人数
    private Integer winLimit;//用户中奖限制
    /**
     * 用户中奖限制维度
     */
    private Integer winLimitScope;
    private String logo;//logo图
    private String otherUse;

    /** 是否库存报警 0:否 1:是 */
    private Integer stockWarning;

    /** 是否加入奖项轮播 0:否 1:是 */
    private Integer rolling;

    /** 发奖限制 json格式
     * @see ActivityPrizeOptionLimitDto
     * */
    private String prizesLimit;

    private Date gmtCreate;
    private Date gmtModified;

    public String getPrizesLimit() {
        return prizesLimit;
    }

    public void setPrizesLimit(String prizesLimit) {
        this.prizesLimit = prizesLimit;
    }

    public Integer getRolling() {
        return rolling;
    }

    public void setRolling(Integer rolling) {
        this.rolling = rolling;
    }

    public String getOtherUse() {
        return otherUse;
    }
    
    public void setOtherUse(String otherUse) {
        this.otherUse = otherUse;
    }

    public Long getId() {
        return id;
    }
    
    public void setId(Long id) {
        this.id = id;
    }
    
    public Long getActivityId() {
        return activityId;
    }
    
    public void setActivityId(Long activityId) {
        this.activityId = activityId;
    }
    
    public String getActivityType() {
        return activityType;
    }
    
    public void setActivityType(String activityType) {
        this.activityType = activityType;
    }
    
    public Long getAppItemId() {
        return appItemId;
    }
    
    public void setAppItemId(Long appItemId) {
        this.appItemId = appItemId;
    }
    
    public Long getItemId() {
        return itemId;
    }
    
    public void setItemId(Long itemId) {
        this.itemId = itemId;
    }
    
    /**
     * 
     * getgId:(这里用一句话描述这个方法的作用). <br/>
     * 
     * @return
     * @since JDK 1.6
     */
    public Long getgId() {
        return gId;
    }
    
    /**
     * 
     * setgId:(这里用一句话描述这个方法的作用). <br/>
     * 
     * @param gId
     * @since JDK 1.6
     */
    public void setgId(Long gId) {
        this.gId = gId;
    }
    
    /**
     * 
     * getgType:(这里用一句话描述这个方法的作用). <br/>
     * 
     * @return
     * @since JDK 1.6
     */
    public String getgType() {
        return gType;
    }
    
    /**
     * 
     * setgType:(这里用一句话描述这个方法的作用). <br/>
     * 
     * @param gType
     * @since JDK 1.6
     */
    public void setgType(String gType) {
        this.gType = gType;
    }
    
    public String getPrizeType() {
        return prizeType;
    }
    
    public void setPrizeType(String prizeType) {
        this.prizeType = prizeType;
    }
    
    public String getFacePrice() {
        return facePrice;
    }
    
    public void setFacePrice(String facePrice) {
        this.facePrice = facePrice;
    }
    
    public Long getStockId() {
        return stockId;
    }
    
    public void setStockId(Long stockId) {
        this.stockId = stockId;
    }
    
    public String getRate() {
        return rate;
    }
    
    public void setRate(String rate) {
        this.rate = rate;
    }
    
    public String getDescription() {
        return description;
    }
    
    public void setDescription(String description) {
        this.description = description;
    }
    
    public Integer getPayload() {
        return payload;
    }
    
    public void setPayload(Integer payload) {
        this.payload = payload;
    }
    
    public Integer getHidden() {
        return hidden;
    }
    
    public void setHidden(Integer hidden) {
        this.hidden = hidden;
    }
    
    public Integer getMinComein() {
        return minComein;
    }
    
    public void setMinComein(Integer minComein) {
        this.minComein = minComein;
    }
    
    public Integer getWinLimit() {
        return winLimit;
    }
    
    public void setWinLimit(Integer winLimit) {
        this.winLimit = winLimit;
    }
    
    public String getLogo() {
        return logo;
    }

    
    public void setLogo(String logo) {
        this.logo = logo;
    }

    public Date getGmtCreate() {
        return gmtCreate;
    }
    
    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
    }
    
    public Date getGmtModified() {
        return gmtModified;
    }
    
    public void setGmtModified(Date gmtModified) {
        this.gmtModified = gmtModified;
    }

    
    public String getPrizeName() {
        return prizeName;
    }

    
    public void setPrizeName(String prizeName) {
        this.prizeName = prizeName;
    }

    public Integer getStockWarning() {
        return stockWarning;
    }

    public void setStockWarning(Integer stockWarning) {
        this.stockWarning = stockWarning;
    }

    public Integer getWinLimitScope() {
        return winLimitScope;
    }

    public void setWinLimitScope(Integer winLimitScope) {
        this.winLimitScope = winLimitScope;
    }
}

