package cn.com.duiba.prize.center.api.remoteservice.prize;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.prize.center.api.dto.prize.ActivityPrizeOptionDto;

import java.util.List;

/**
 * 迁移自活动中心
 * Created by hww on 2018/6/6 下午2:42.
 */
@AdvancedFeignClient
public interface RemoteActivityPrizeOptionService {

    /**
     * 根据id查询奖项
     * @author zp
     * @param id
     * @return
     * @since JDK 1.6
     */
    ActivityPrizeOptionDto find(Long id);

    /**
     * 删除奖项
     * @author zp
     * @param optionId
     * @return
     * @since JDK 1.6
     */
    Boolean delOption(Long optionId);

    /**
     * 保存/编辑奖项
     * @author zp
     * @param prizeOption
     * @return
     * @since JDK 1.6
     */
    Long saveOrUpdateOption(ActivityPrizeOptionDto prizeOption);

    /**
     * 根据活动id查询奖项
     * queryActivityOptionsByConfigId:(这里用一句话描述这个方法的作用). <br/>
     * @author zp
     * @param configId
     * @param activityType
     * @return
     * @since JDK 1.6
     */
    List<ActivityPrizeOptionDto> queryActivityOptionsByConfigId(Long configId, String activityType);

    /**
     * 根据活动id查询奖项
     * @param configIds
     * @param activityType
     * @param prizeType
     * @return
     */
    List<ActivityPrizeOptionDto> queryCouponActivityOptionsByIds(List<Long> configIds,String activityType, String prizeType);

    /**
     * 根据活动id 批量查询奖项
     * queryActivityOptionsByConfigIds. <br/>
     *
     * @author wubo
     * @param configIds
     * @param activityType
     * @return
     * @since JDK 1.6
     */
    List<ActivityPrizeOptionDto> queryActivityOptionsByConfigIds(List<Long> configIds,String activityType);

    /**
     *
     * queryActivityOptionByActivityType:(这里用一句话描述这个方法的作用). <br/>
     * 根据活动类型查询
     * @param activityType
     * @param offset
     * @param max
     * @return
     * @since JDK 1.6
     */
    List<ActivityPrizeOptionDto> queryActivityOptionByActivityType(String activityType,Integer offset,Integer max) throws BizException;

    /**
     * queryCountByActivityType:(查询某活动类型的个数)<br/>
     * @author wubo
     * @param activityType
     * @return
     * @since JDK 1.6
     */
    Long queryCountByActivityType(String activityType) throws BizException;

    /**
     * queryRandomGift:(随机查询一些礼包，可以过滤一些id). <br/>
     *
     * @author wubo
     * @param number 个数
     * @param ids 要过滤的id
     * @return
     * @since JDK 1.6
     */
    List<ActivityPrizeOptionDto> queryRandomGift(Integer number,List<Long> ids) throws BizException;

    /**
     * 签到根据活动id查询给定天数的奖项
     * queryActivityOptionsByConfigIdAndDays:(这里用一句话描述这个方法的作用). <br/>
     * @author liyang
     * @param configId
     * @param activityType
     * @param otherUse
     * @return
     * @since JDK 1.6
     */
    List<ActivityPrizeOptionDto> queryActivityOptionsByConfigIdAndDays(Long configId,String activityType, String otherUse);


    /**
     * 根据活动类型查询所有需要发送告警邮件的奖项
     * @param activityType
     * @return
     */
    List<ActivityPrizeOptionDto> findWarningOption(String activityType);
}
