package cn.com.duiba.prize.center.api.dto.prize;

import java.io.Serializable;

/**
 * 中奖信息基础类
 * Created by xiaoxuda on 2018/4/21.
 */
public class PrizeResultBaseDto implements Serializable{
    private static final long serialVersionUID = -3896761923063734244L;

    private Lottery lottery;
    private Integer result;
    private String message;
    private Exposure exposure;
    private Boolean takeSuccess;
    private String url;
    private String againTag;
    private CreditsInfo creditsInfo;

    public String getAgainTag() {
        return againTag;
    }

    public void setAgainTag(String againTag) {
        this.againTag = againTag;
    }

    public Boolean getTakeSuccess() {
		return takeSuccess;
	}

	public void setTakeSuccess(Boolean takeSuccess) {
		this.takeSuccess = takeSuccess;
	}

	public String getUrl() {
		return url;
	}

	public void setUrl(String url) {
		this.url = url;
	}

	public Lottery getLottery() {
        return lottery;
    }

    public void setLottery(Lottery lottery) {
        this.lottery = lottery;
    }

    public Integer getResult() {
        return result;
    }

    public void setResult(Integer result) {
        this.result = result;
    }

    public String getMessage() {
        return message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public Exposure getExposure() {
		return exposure;
	}

	public CreditsInfo getCreditsInfo() {
		return creditsInfo;
	}

	public void setCreditsInfo(CreditsInfo creditsInfo) {
		this.creditsInfo = creditsInfo;
	}

	public void setExposure(Exposure exposure) {
		this.exposure = exposure;
	}

	public static class Lottery implements Serializable{
        private static final long serialVersionUID = 2953695790953482449L;
        /**
         * prizeId
         */
        private Long id;
        /**
         * prizeType
         */
        private String type;
        /**
         * imgurl
         */
        private String imgurl;
        /**
         * link
         */
        private String link;
        /**
         * 奖品名称
         */
        private String title;
        /**
         * 奖品名称
         */
        private Long itemId;
        /**
         * 奖品名称
         */
        private Long appItemId;
        /**
         * 集卡红包金额
         */
        private Long bonus;
		/**
		 * 集卡商品-随机红包金额区间最小值
		 */
		private Long bonusMin;
		/**
		 * 集卡商品-随机红包金额区间最大值
		 */
		private Long bonusMax;
        /**
         * 需要输入 账户信息
         */
        private Boolean needAccount;

        private Boolean isDownloadUrl;
        
        /**
         * 谢谢参与转福袋
         */
        private Boolean isAppLucky;

        private Integer linkTo;
        /**
         * 福袋使用
         */
        private String tip;
        
        /**
         * 按钮文案
         */
        private String useBtnText;
        /** 
         * 优惠券有效期的结束时间. 
         * 
         */
        private String validate;
        
        /** 
         * 优惠券券码. 
         * 
         */
        private String coupon_code;
        /** 
         * 优惠券券密码. 
         * 
         */
        private String coupon_key;
        
        /** 
         * st_info_dpm_img. 
         * 
         */
        private String st_info_dpm_img;
        
        /** 
         * st_info_dpm_close. 
         * 
         */
        private String st_info_dpm_close;
        
        /** 
         * st_info_dpm_go_use. 
         * 
         */
        private String st_info_dpm_go_use;
        
        /** 
         * 马上使用按钮是否展示
         * 
         */
        private Boolean showUse;
        /** 
         * 打开应用
         * 
         */
        private String openUrl;
        /** 
         * 打开应用
         * 
         */
        private String iosDownloadUrl;
        /** 
         * 打开应用
         * 
         */
        private String androidDownloadUrl;
        
        /** 
         * 打开应用
         * 
         */
        private Boolean confirm;

		/**
		 * 开心码期次号
		 */
		private String phaseNumber;

		/**
		 * 开心码
		 */
		private String happyCode;

		/** 福袋是否在兑换记录中隐藏 */
		private boolean isAppHidden = true;

		//作业帮定制接口返回参数
		private String zybangJson;

		public boolean getIsAppHidden() {
			return isAppHidden;
		}

		public void setIsAppHidden(boolean isAppHidden) {
			this.isAppHidden = isAppHidden;
		}

		public String getPhaseNumber() {
			return phaseNumber;
		}

		public void setPhaseNumber(String phaseNumber) {
			this.phaseNumber = phaseNumber;
		}

		public String getHappyCode() {
			return happyCode;
		}

		public void setHappyCode(String happyCode) {
			this.happyCode = happyCode;
		}

		public Boolean getConfirm() {
			return confirm;
		}

		public void setConfirm(Boolean confirm) {
			this.confirm = confirm;
		}

		public Boolean getShowUse() {
			return showUse;
		}

		public void setShowUse(Boolean showUse) {
			this.showUse = showUse;
		}

		public String getOpenUrl() {
			return openUrl;
		}

		public void setOpenUrl(String openUrl) {
			this.openUrl = openUrl;
		}

		public String getIosDownloadUrl() {
			return iosDownloadUrl;
		}

		public void setIosDownloadUrl(String iosDownloadUrl) {
			this.iosDownloadUrl = iosDownloadUrl;
		}

		public String getAndroidDownloadUrl() {
			return androidDownloadUrl;
		}

		public void setAndroidDownloadUrl(String androidDownloadUrl) {
			this.androidDownloadUrl = androidDownloadUrl;
		}

		public String getSt_info_dpm_close() {
			return st_info_dpm_close;
		}

		public void setSt_info_dpm_close(String st_info_dpm_close) {
			this.st_info_dpm_close = st_info_dpm_close;
		}

		public String getSt_info_dpm_go_use() {
			return st_info_dpm_go_use;
		}

		public void setSt_info_dpm_go_use(String st_info_dpm_go_use) {
			this.st_info_dpm_go_use = st_info_dpm_go_use;
		}

		public String getSt_info_dpm_img() {
			return st_info_dpm_img;
		}

		public void setSt_info_dpm_img(String st_info_dpm_img) {
			this.st_info_dpm_img = st_info_dpm_img;
		}

		public String getCoupon_code() {
			return coupon_code;
		}

		public void setCoupon_code(String coupon_code) {
			this.coupon_code = coupon_code;
		}

		public String getCoupon_key() {
			return coupon_key;
		}

		public void setCoupon_key(String coupon_key) {
			this.coupon_key = coupon_key;
		}

		public Long getId() {
            return id;
        }

        public void setId(Long id) {
            this.id = id;
        }

        public String getType() {
            return type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public String getImgurl() {
            return imgurl;
        }

        public void setImgurl(String imgurl) {
            this.imgurl = imgurl;
        }

        public String getLink() {
            return link;
        }

        public void setLink(String link) {
            this.link = link;
        }

        public String getTitle() {
            return title;
        }

        public void setTitle(String title) {
            this.title = title;
        }

        public Boolean getNeedAccount() {
            return needAccount;
        }

        public void setNeedAccount(Boolean needAccount) {
            this.needAccount = needAccount;
        }

        public Boolean getIsDownloadUrl() {
            return isDownloadUrl;
        }

        public void setIsDownloadUrl(Boolean isDownloadUrl) {
        	this.isDownloadUrl = isDownloadUrl;
        }

        public Integer getLinkTo() {
            return linkTo;
        }

        public void setLinkTo(Integer linkTo) {
            this.linkTo = linkTo;
        }
        
        public Long getItemId() {
			return itemId;
		}

		public void setItemId(Long itemId) {
			this.itemId = itemId;
		}

		public Long getAppItemId() {
			return appItemId;
		}

		public void setAppItemId(Long appItemId) {
			this.appItemId = appItemId;
		}

		public Long getBonus() {
			return bonus;
		}

		public void setBonus(Long bonus) {
			this.bonus = bonus;
		}

		public Long getBonusMin() {
			return bonusMin;
		}

		public void setBonusMin(Long bonusMin) {
			this.bonusMin = bonusMin;
		}

		public Long getBonusMax() {
			return bonusMax;
		}

		public void setBonusMax(Long bonusMax) {
			this.bonusMax = bonusMax;
		}

		public Boolean getIsAppLucky() {
			return isAppLucky;
		}

		public void setIsAppLucky(Boolean isAppLucky) {
			this.isAppLucky = isAppLucky;
		}

		public String getTip() {
			return tip;
		}

		public void setTip(String tip) {
			this.tip = tip;
		}

		public String getUseBtnText() {
			return useBtnText;
		}

		public void setUseBtnText(String useBtnText) {
			this.useBtnText = useBtnText;
		}

		public String getValidate() {
			return validate;
		}

		public void setValidate(String validate) {
			this.validate = validate;
		}

		public String getZybangJson() {
			return zybangJson;
		}

		public void setZybangJson(String zybangJson) {
			this.zybangJson = zybangJson;
		}
	}

    public static class Exposure implements Serializable{

		/**
		 * 
		 */
		private static final long serialVersionUID = -6909106238100271759L;
		//活动id  
		private Long activityId;
	    /** 广告位ID */
	    private Long              slotId;
		private String activityUseType;
		private Long advertId;
		private Long appId;
		private Long consumerId;
		private String dcm;
		private String domain;
		private String dpm;
		private String ip;
		private Boolean isEmbed;
		private Long materialId;
		private String orderId;
		private String os;
		public Long getActivityId() {
			return activityId;
		}
		public void setActivityId(Long activityId) {
			this.activityId = activityId;
		}
		public String getActivityUseType() {
			return activityUseType;
		}
		public void setActivityUseType(String activityUseType) {
			this.activityUseType = activityUseType;
		}
		public Long getAdvertId() {
			return advertId;
		}
		public void setAdvertId(Long advertId) {
			this.advertId = advertId;
		}
		public Long getAppId() {
			return appId;
		}
		public void setAppId(Long appId) {
			this.appId = appId;
		}
		public Long getConsumerId() {
			return consumerId;
		}
		public void setConsumerId(Long consumerId) {
			this.consumerId = consumerId;
		}
		public String getDcm() {
			return dcm;
		}
		public void setDcm(String dcm) {
			this.dcm = dcm;
		}
		public String getDomain() {
			return domain;
		}
		public void setDomain(String domain) {
			this.domain = domain;
		}
		public String getDpm() {
			return dpm;
		}
		public void setDpm(String dpm) {
			this.dpm = dpm;
		}
		public String getIp() {
			return ip;
		}
		public void setIp(String ip) {
			this.ip = ip;
		}
		public Boolean getIsEmbed() {
			return isEmbed;
		}
		public void setIsEmbed(Boolean isEmbed) {
			this.isEmbed = isEmbed;
		}
		public Long getMaterialId() {
			return materialId;
		}
		public void setMaterialId(Long materialId) {
			this.materialId = materialId;
		}
		public String getOrderId() {
			return orderId;
		}
		public void setOrderId(String orderId) {
			this.orderId = orderId;
		}
		public String getOs() {
			return os;
		}
		public void setOs(String os) {
			this.os = os;
		}
		public Long getSlotId() {
			return slotId;
		}
		public void setSlotId(Long slotId) {
			this.slotId = slotId;
		}
    }
}
