package cn.com.duiba.prize.center.api.enums;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;

import java.util.Map;

/**
 * @deprecated
 * 奖项关联的活动类型枚举
 * 对应tb_activity_center_option表的activity_type字段
 * 移动到了duiba-api,@See cn.com.duiba.api.enums.prize.PrizeRelTypeEnum
 */
@Deprecated
public enum ActivityTypeForOptionEnum {
    ROB("rob", "今日必抢"),
    PLUGIN("plugin", "插件活动&插件式抽奖工具"),
    SIGN("sign", "签到活动"),
    CREDITS_GAME("creditgame", "积分游戏"),
    LITTLE_GAME("littlegame", "小游戏"),

    SIGN_FOR_NEW_7("sign_for_new7", "拉新日历签到七日奖励"),

    SIGN_1("sign_1", "连续奖励签到"),
    SIGN_2("sign_2", "周期奖励签到"),
    SIGN_3("sign_3", "累计奖励签到"),
    SIGN_4("sign_4", "特殊日期奖励签到"),
    SIGN_5("sign_5", "首次签到奖励签到"),
    SIGN_6("sign_6", "满签奖励签到"),
    SIGN_7("sign_7", "连续累计奖励签到"),

    PK_H5("pk_h5", "pk营销落地页H5"),
    ;

    //所有枚举的 type-enum 映射
    private static final ImmutableMap<String, ActivityTypeForOptionEnum> ALL;
    static {
        Map<String, ActivityTypeForOptionEnum> temp = Maps.newHashMap();
        for (ActivityTypeForOptionEnum e : values()) {
            temp.put(e.getType(), e);
        }
        ALL = ImmutableMap.copyOf(temp);
    }

    private String type;

    private String desc;

    ActivityTypeForOptionEnum(String type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public static boolean isExist(String type) {
        return ALL.get(type) != null;
    }



}
