package cn.com.duiba.prize.center.api.dto.galaxy;

import lombok.Getter;
import lombok.Setter;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;


/**
 * 扣除积分请求
 *
 * @author fangxiaorun
 * @date 2022/10/24
 */
@Getter
@Setter
public class DeductCreditsRequest implements Serializable {
    private static final long serialVersionUID = 3657536342785895929L;
    /**
     * 应用id
     */
    @NotNull
    private Long appId;
    /**
     * 用户id
     */
    @NotNull
    private Long consumerId;
    /**
     * 项目订单号
     */
    @NotBlank
    private String projectOrderNo;
    /**
     * 积分
     */
    @NotNull
    private Long credits;
    /**
     * 扣积分描述
     */
    @NotBlank
    private String description;
    /**
     * transfer参数
     */
    private String transfer;
    /**
     * ip
     */
    private String ip;


    private String galaxyProjectId;
}
