package cn.com.duiba.prize.center.api.dto.projectx;

import java.io.Serializable;

/**
 * @author zhangruofan
 * @date 2019/06/27
 */
public class AwardRequest implements Serializable {
    private static final long serialVersionUID = -7631843645804747471L;

    public static final String INCREASE_CREDITS = "increase-credits";

    /**
     * 福袋渠道
     */
    public static final String EXT_JSON_LUCKY_CHANNEL = "luckyChannel";
    /**
     * os
     */
    public static final String EXT_JSON_OS = "os";
    /**
     * 是否是代理流量
     */
    public static final String EXT_JSON_PROXY = "isProxy";



    /**
     * 发奖记录id，project x调用时无需指定
     */
    private Long prizeRecordId;
    /**
     * project x id
     * 必传
     */
    private String projectId;
    /**
     * project x order no
     * 必传
     */
    private String projectOrderNo;
    /**
     * 开发者扣积分订单号
     * 如果有扣积分则传
     * 非必传
     */
    private String developerBizId;
    private Long consumerId;
    private Long appId;
    private String userAgent;
    /**
     * 开发者商品id
     * 和兑吧商品必须有一个存在
     */
    private Long itemId;
    /**
     * 兑吧商品id
     * 和开发者商品必须有一个存在
     */
    private Long appItemId;
    /**
     * 档位
     * 当subType=virtual,increase-credits时不能为空
     * 非必传
     */
    private String degree;
    /**
     * 兑吧商品类型 如果是兑吧商品需要传子类型
     * 增加积分类型为increase-credits
     * 必传
     */
    private String itemType;
    private String ip;
    /**
     * 如果cookie里有则传
     * 非必传
     */
    private String transfer;

    private String description;

    /**
     * 虚拟商品账号
     */
    private String account;

//    /**
//     * 来源
//     * @see
//     */
//    private Integer awardSource;

    /**
     * 附加信息,json格式
     */
    private String extJson;

    /**
     * 星速台项目名称
     */
    private String projectName;

    public String getProjectName() {
        return projectName;
    }

    public AwardRequest setProjectName(String projectName) {
        this.projectName = projectName;
        return this;
    }

    //    public Integer getAwardSource() {
//        return awardSource;
//    }
//
//    public void setAwardSource(Integer awardSource) {
//        this.awardSource = awardSource;
//    }

    public Long getAppItemId() {
        return appItemId;
    }

    public void setAppItemId(Long appItemId) {
        this.appItemId = appItemId;
    }

    public String getAccount() {
        return account;
    }

    public void setAccount(String account) {
        this.account = account;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Long getPrizeRecordId() {
        return prizeRecordId;
    }

    public void setPrizeRecordId(Long prizeRecordId) {
        this.prizeRecordId = prizeRecordId;
    }

    public String getDeveloperBizId() {
        return developerBizId;
    }

    public void setDeveloperBizId(String developerBizId) {
        this.developerBizId = developerBizId;
    }

    public String getUserAgent() {
        return userAgent;
    }

    public void setUserAgent(String userAgent) {
        this.userAgent = userAgent;
    }

    public String getProjectId() {
        return projectId;
    }

    public void setProjectId(String projectId) {
        this.projectId = projectId;
    }

    public Long getAppId() {
        return appId;
    }

    public void setAppId(Long appId) {
        this.appId = appId;
    }

    public String getProjectOrderNo() {
        return projectOrderNo;
    }

    public void setProjectOrderNo(String projectOrderNo) {
        this.projectOrderNo = projectOrderNo;
    }

    public Long getConsumerId() {
        return consumerId;
    }

    public void setConsumerId(Long consumerId) {
        this.consumerId = consumerId;
    }

    public String getDegree() {
        return degree;
    }

    public void setDegree(String degree) {
        this.degree = degree;
    }

    public Long getItemId() {
        return itemId;
    }

    public void setItemId(Long itemId) {
        this.itemId = itemId;
    }

    public String getItemType() {
        return itemType;
    }

    public void setItemType(String itemType) {
        this.itemType = itemType;
    }

    public String getIp() {
        return ip;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public String getTransfer() {
        return transfer;
    }

    public void setTransfer(String transfer) {
        this.transfer = transfer;
    }

    public String getExtJson() {
        return extJson;
    }

    public void setExtJson(String extJson) {
        this.extJson = extJson;
    }
}
