package cn.com.duiba.prize.center.api.enums;

/**
 * ClassName:PrizeCenterErrorEnum<br/>
 *
 * @author gey
 * @version 1.0
 * @Description: 错误码 统一定义   规范参考http://cf.dui88.com/pages/viewpage.action?pageId=7676317
 * @date 创建时间：2018/3/14  11:23
 * @since JDK 1.8
 **/
public enum PrizeCenterErrorEnum {
    CODE_2003001001("2003001001", "暂时不支持查询改类型活动奖品配置"),
    CODE_2003001002("2003001002", "活动工具奖品配置获取异常"),
    CODE_2003001003("2003001003", "商品未找到"),
    CODE_2003001004("2003001004", "商品失效"),
    CODE_2003001005("2003001005", "商品删除或下架"),
    CODE_2003001006("2003001006", "限时,限量,会员等级限制,兑换限制,日期限制"),
    CODE_2003001007("2003001007", "APP兑换限制只能测试专用商品"),
    CODE_2003001008("2003001008", "商品库存不足"),
    CODE_2003001009("2003001009", "商品过期"),
    CODE_2003001010("2003001010", "虚拟商品接口未配"),
    CODE_2003001011("2003001011", "虚拟商品档位不存在"),
    CODE_2003001012("2003001012", "地域限制"),
    CODE_2003001013("2003001013", "兑吧余额不足"),
    CODE_2003001014("2003001014", "开发者日预算不足"),
    CODE_2003001015("2003001015", "开发者月预算不足"),
    CODE_2003001016("2003001016", "开发者余额不足"),
    CODE_2003001017("2003001017", "保底人数不够"),
    CODE_2003001018("2003001018", "奖项中奖限制"),
    CODE_2003001019("2003001019", "防作弊命中"),
    CODE_2003002001("2003002001", "防作弊命中"),
    CODE_2003002002("2003002002", "开发者子账户余额不足"),

    CODE_2003003001("2003003001", "主订单生成失败"),
    CODE_2003003002("2003003002", "虚拟商品订单生成失败"),
    CODE_2003003003("2003003003", "APP交易数限制"),
    CODE_2003003004("2003003004", "APP交易数限制下只能兑换测试专用券"),
    CODE_2003003005("2003003005", "没有权限"),
    CODE_2003003006("2003003006", "商品下架"),
    CODE_2003003007("2003003007", "优惠券订单生成失败"),
    CODE_2003003008("2003003008", "商品类型错误"),
    CODE_2003003009("2003003009", "非兑吧付费商品"),
    CODE_2003003010("2003003010", "非加钱购商品"),
    CODE_2003003011("2003003011", "查询商品异常"),


    CODE_2003004001("2003004001", "item 扣库存失败"),
    CODE_2003004002("2003004002", "扣奖项库存失败"),
    CODE_2003004003("2003004003", "返还项库存失败"),
    CODE_2003004004("2003004004", "预分配库存不存在"),
    CODE_2003004005("2003004005", "预分配库存不足"),
    CODE_2003004006("2003004006", "更新兑吧活动奖项预分配库存异常"),
    CODE_2003004007("2003004007", "更新兑吧活动奖项预分配个数异常"),
    CODE_2003004008("2003004008", "奖项不存在"),
    CODE_2003004009("2003004009", "库存不足"),
    CODE_2003004010("2003004010", "充值红包金额失败"),
    CODE_2003004011("2003004011", "集卡规则查询失败"),
    CODE_2003004012("2003004012", "集卡规则多奖项命中"),
    CODE_2003004013("2003004013", "集卡规则-用户中奖限制命中"),
    CODE_2003004014("2003004014", "集卡规则-奖品库存不足"),
    CODE_2003004015("2003004015", "闯关游戏 重新出奖品"),
    CODE_2003004016("2003004016", "闯关游戏 奖品异常 重新出奖品"),
    CODE_2003004017("2003004017", "插件领奖异常，奖品降级为谢谢参与"),

    CODE_2003005001("2003005001", "订单生成失败"),
    CODE_2003005002("2003005002", "获取优惠券id失败"),
    CODE_2003006001("2003006001", "订单查询异常"),

    //开心码业务 错误码2003007xxx
    CODE_2003007001("2003007001", "获取开心码失败"),
    CODE_2003007002("2003007002", "appId不能为空"),
    CODE_2003007003("2003007003", "赛事Id不能为空"),
    CODE_2003007004("2003007004", "兑吧用户Id不能为空"),
    CODE_2003007005("2003007005", "开发者用户Id不能为空"),
    CODE_2003007006("2003007006", "请求来源不能为空"),
    CODE_2003007007("2003007007", "库存不足"),
    CODE_2003007008("2003007008", "扣库存失败"),
    CODE_2003007009("2003007009", "更新开心码子订单失败"),
    CODE_2003007010("2003007010", "开心码活动减库存失败"),
    //开心码业务扑克牌
    CODE_2003007011("2003007011", "需要符合牌数量大于当前牌组数量"),
    CODE_2003007012("2003007012", "需要符合牌数量或需符合数量为空"),
    CODE_2003007013("2003007013", "生成牌组数量<=0"),


    //活动奖项 错误码2003008xxx
    CODE_2003008001("2003008001", "查询奖项列表失败"),
    CODE_2003008002("2003008002", "查询奖项数量失败"),
    CODE_2003008003("2003008003", "请输入查询的个数"),

    //爱奇艺定制
    CODE_2003009001("2003009001", "爱奇艺 账户加钱失败"),

    //作业帮
    CODE_2003010001("2003010001", "接口返回为null"),
    CODE_2003010002("2003010002", "接口返回异常"),
    CODE_2003010003("2003010003", "作业帮操作hbase异常"),
    CODE_2003010004("2003010004", "作业帮发券异常"),
    CODE_2003010005("2003010005", "作业帮发送http请求异常"),
    CODE_2003010006("2003010006", "作业帮关闭response异常"),


    CODE_2003011001("2003011001", "激励广告异常"),

    //客集集 定制
    CODE_2003012001("2003012001", "参数不正确"),

    //风控
    CODE_2003013001("2003013001", "命中风控规则"),

    // 奖品中心定向适配活动平台[duiba-galaxy]提供下游服务，错误码
    CODE_2003014001("2003014001", "参数错误"),
    CODE_2003014002("2003014002", "非法的参数校验分组"),
    CODE_2003014003("2003014003", "用户不存在"),
    CODE_2003014004("2003014004", "应用不存在"),

    CODE_2003004019("2003004019", "库存锁定失败，无需退还库存"),
    ;

    //错误码
    private String code;
    //错误信息
    private String msg;


    PrizeCenterErrorEnum(String code, String msg) {
        this.code = code;
        this.msg = msg;
    }

    public String getCode() {
        return code;
    }

    public String getMsg() {
        return msg;
    }
}
