package cn.com.duiba.prize.center.api.remoteservice.creditscnfo;

import java.util.List;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.prize.center.api.dto.creditscnfo.CreditsConfDto;

/**
 * ClassName:RemoteCreditsConfBackendService<br/>
 *
 * @author gey
 * @version 1.0
 * @Description: 兑吧活动工具积分配置
 * @date 创建时间：2018/12/22  17:10
 * @since JDK 1.8
 **/
@AdvancedFeignClient
public interface RemoteCreditsConfBackendService {

	/**
	 * 根据活动能够id 查询积分配置信息
	 * 
	 * @param activityId
	 * 
	 * @return
	 */
	List<CreditsConfDto> findByActivityId(Long activityId);
	
	/**
	 * 保存 积分配置信息
	 * 
	 * @param activityId
	 * @param adminId
	 * @param info
	 * 
	 * @return
	 */
	void saveCreditsConf(Long activityId,Long adminId,List<CreditsConfDto> info);
}
